/*
 * Decompiled with CFR 0.152.
 */
package de.pellepelster.jenkins.walldisplay;

import hudson.Extension;
import hudson.model.AbstractProject;
import hudson.model.Descriptor;
import hudson.model.Job;
import hudson.model.JobProperty;
import hudson.model.JobPropertyDescriptor;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;

@ExportedBean
public final class WallDisplayJobProperty
extends JobProperty<AbstractProject<?, ?>> {
    private String wallDisplayName = null;
    private String wallDisplayBgPicture = null;
    private String wallDisplayOrder = null;

    @DataBoundConstructor
    public WallDisplayJobProperty(String wallDisplayName, String wallDisplayBgPicture, String wallDisplayOrder) {
        this.wallDisplayName = wallDisplayName;
        this.wallDisplayBgPicture = wallDisplayBgPicture;
        this.wallDisplayOrder = wallDisplayOrder;
    }

    @Exported
    public String getWallDisplayName() {
        return this.wallDisplayName;
    }

    @Exported
    public String getWallDisplayBgPicture() {
        return this.wallDisplayBgPicture;
    }

    @Exported
    public String getWallDisplayOrder() {
        return this.wallDisplayOrder;
    }

    @Extension
    public static final class DescriptorImpl
    extends JobPropertyDescriptor {
        public DescriptorImpl() {
            super(WallDisplayJobProperty.class);
            this.load();
        }

        public boolean isApplicable(Class<? extends Job> jobType) {
            return AbstractProject.class.isAssignableFrom(jobType);
        }

        public String getDisplayName() {
            return "Walldisplay";
        }

        public String getBgPicture() {
            return "";
        }

        public String getOrder() {
            return "";
        }

        public JobProperty<?> newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            JSONObject wallDisplayOrderDynamic;
            JSONObject wallDisplayBgPictureDynamic;
            JSONObject wallDisplayNameDynamic;
            String wallDisplayName = null;
            String wallDisplayBgPicture = null;
            String wallDisplayOrder = null;
            if (formData.has("wallDisplayNameDynamic") && (wallDisplayNameDynamic = formData.getJSONObject("wallDisplayNameDynamic")) != null && wallDisplayNameDynamic.has("wallDisplayName") && !wallDisplayNameDynamic.get("wallDisplayName").toString().trim().isEmpty()) {
                wallDisplayName = wallDisplayNameDynamic.get("wallDisplayName").toString();
            }
            if (formData.has("wallDisplayBgPictureDynamic") && (wallDisplayBgPictureDynamic = formData.getJSONObject("wallDisplayBgPictureDynamic")) != null && wallDisplayBgPictureDynamic.has("wallDisplayBgPicture") && !wallDisplayBgPictureDynamic.get("wallDisplayBgPicture").toString().trim().isEmpty()) {
                wallDisplayBgPicture = wallDisplayBgPictureDynamic.getString("wallDisplayBgPicture").toString();
            }
            if (formData.has("wallDisplayOrderDynamic") && (wallDisplayOrderDynamic = formData.getJSONObject("wallDisplayOrderDynamic")) != null && wallDisplayOrderDynamic.has("wallDisplayOrder") && !wallDisplayOrderDynamic.get("wallDisplayOrder").toString().trim().isEmpty()) {
                wallDisplayOrder = wallDisplayOrderDynamic.get("wallDisplayOrder").toString();
            }
            return new WallDisplayJobProperty(wallDisplayName, wallDisplayBgPicture, wallDisplayOrder);
        }
    }
}

