/*
 * Decompiled with CFR 0.152.
 */
package de.pellepelster.jenkins.walldisplay;

import de.pellepelster.jenkins.walldisplay.WallDisplayPlugin;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;

@ExportedBean
public class Configuration {
    private String theme = WallDisplayPlugin.themes[0];
    private String fontFamily = WallDisplayPlugin.fontFamilies[0];
    private String buildRange = WallDisplayPlugin.buildRange[0];
    private String sortOrder = WallDisplayPlugin.sortOrder[0];
    private String customTheme = ".custom {\r\n        background-color: #000000;\r\n}\r\n.custom.blue {\r\n        background-color: #00CC00;\r\n}\r\n.custom.red, .custom.yellow, .custom.aborted, .custom.grey {\r\n        background-color: #CC0000;\r\n}\r\n.custom.claimed {\r\n        background-color: #0000CC;\r\n}\r\n";
    private int jenkinsTimeOut = 15;
    private int jenkinsUpdateInterval = 20;
    private int paintInterval = 1;
    private int maxQueuePositionToShow = 15;
    private Boolean showDetails = false;
    private Boolean showGravatar = false;
    private Boolean showJunitResults = false;
    private Boolean showBuildNumber = true;
    private Boolean showLastStableTimeAgo = true;
    private Boolean showDisabledBuilds = true;
    private Boolean showWeatherReport = false;
    private Boolean blinkBgPicturesWhenBuilding = false;
    private String gravatarUrl = "http://www.gravatar.com/avatar/";

    @Exported
    public Boolean getShowBuildNumber() {
        return this.showBuildNumber;
    }

    @Exported
    public Boolean getShowJunitResults() {
        return this.showJunitResults;
    }

    public void setShowBuildNumber(Boolean showBuildNumber) {
        this.showBuildNumber = showBuildNumber;
    }

    public void setMaxQueuePositionToShow(int maxQueuePositionToShow) {
        this.maxQueuePositionToShow = maxQueuePositionToShow;
    }

    @Exported
    public int getMaxQueuePositionToShow() {
        return this.maxQueuePositionToShow;
    }

    @Exported
    public Boolean getShowLastStableTimeAgo() {
        return this.showLastStableTimeAgo;
    }

    public void setShowLastStableTimeAgo(Boolean showLastStableTimeAgo) {
        this.showLastStableTimeAgo = showLastStableTimeAgo;
    }

    @Exported
    public Boolean getShowDisabledBuilds() {
        return this.showDisabledBuilds;
    }

    public void setShowDisabledBuilds(Boolean showDisabledBuilds) {
        this.showDisabledBuilds = showDisabledBuilds;
    }

    @Exported
    public int getJenkinsTimeOut() {
        return this.jenkinsTimeOut;
    }

    public void setJenkinsTimeOut(int jenkinsTimeOut) {
        if (jenkinsTimeOut > 0) {
            this.jenkinsTimeOut = jenkinsTimeOut;
        }
    }

    @Exported
    public int getJenkinsUpdateInterval() {
        return this.jenkinsUpdateInterval;
    }

    public void setJenkinsUpdateInterval(int jenkinsUpdateInterval) {
        if (jenkinsUpdateInterval > 0) {
            this.jenkinsUpdateInterval = jenkinsUpdateInterval;
        }
    }

    @Exported
    public String getSortOrder() {
        if (this.sortOrder != null) {
            return this.sortOrder.toLowerCase();
        }
        return this.sortOrder;
    }

    public void setSortOrder(String sortOrder) {
        this.sortOrder = sortOrder;
    }

    @Exported
    public String getTheme() {
        if (this.theme != null) {
            return this.theme.toLowerCase();
        }
        return this.theme;
    }

    public Boolean isValid() {
        return this.theme != null && this.buildRange != null;
    }

    public void setTheme(String theme) {
        this.theme = theme;
    }

    @Exported
    public String getBuildRange() {
        if (this.buildRange != null) {
            return this.buildRange.toLowerCase();
        }
        return this.buildRange;
    }

    public void setBuildRange(String buildRange) {
        this.buildRange = buildRange;
    }

    @Exported
    public boolean getShowDetails() {
        return this.showDetails;
    }

    public void setShowDetails(Boolean showDetails) {
        this.showDetails = showDetails;
    }

    public void setShowJunitResults(Boolean showJunitResults) {
        this.showJunitResults = showJunitResults;
    }

    @Exported
    public Boolean getShowGravatar() {
        return this.showGravatar;
    }

    public void setShowGravatar(Boolean showGravatar) {
        this.showGravatar = showGravatar;
    }

    @Exported
    public int getPaintInterval() {
        return this.paintInterval;
    }

    public void setPaintInterval(int paintInterval) {
        this.paintInterval = paintInterval;
    }

    @Exported
    public String getFontFamily() {
        if (this.fontFamily != null) {
            return this.fontFamily.toLowerCase();
        }
        return this.fontFamily;
    }

    public void setFontFamily(String fontFamily) {
        this.fontFamily = fontFamily;
    }

    @Exported
    public Boolean getBlinkBgPicturesWhenBuilding() {
        return this.blinkBgPicturesWhenBuilding;
    }

    public void setBlinkBgPicturesWhenBuilding(Boolean blinkBgPicturesWhenBuilding) {
        this.blinkBgPicturesWhenBuilding = blinkBgPicturesWhenBuilding;
    }

    @Exported
    public String getCustomTheme() {
        return this.customTheme;
    }

    public void setCustomTheme(String customTheme) {
        this.customTheme = customTheme;
    }

    @Exported
    public String getGravatarUrl() {
        return this.gravatarUrl;
    }

    public void setGravatarUrl(String gravatarUrl) {
        this.gravatarUrl = gravatarUrl;
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).append("theme", (Object)this.theme).append("jenkinsTimeOut", this.jenkinsTimeOut).append("jenkinsUpdateInterval", this.jenkinsUpdateInterval).append("showDetails", (Object)this.showDetails).append("showGravatar", (Object)this.showGravatar).append("fontFamily", (Object)this.fontFamily).append("buildRange", (Object)this.buildRange).append("sortOrder", (Object)this.sortOrder).append("showWeatherReport", (Object)this.showWeatherReport).append("showJunitResults", (Object)this.showJunitResults).append("maxQueuePositionToShow", this.maxQueuePositionToShow).append("gravatarUrl", (Object)this.gravatarUrl).toString();
    }

    @Exported
    public Boolean getShowWeatherReport() {
        return this.showWeatherReport;
    }

    public void setShowWeatherReport(Boolean showWeatherReport) {
        this.showWeatherReport = showWeatherReport;
    }
}

