/*
 * Decompiled with CFR 0.152.
 */
package jenkinsci.plugins.influxdb.generators;

import hudson.model.Run;
import hudson.plugins.performance.actions.PerformanceBuildAction;
import hudson.plugins.performance.reports.PerformanceReport;
import java.util.ArrayList;
import java.util.Map;
import jenkinsci.plugins.influxdb.generators.AbstractPointGenerator;
import jenkinsci.plugins.influxdb.renderer.MeasurementRenderer;
import org.influxdb.dto.Point;

public class PerformancePointGenerator
extends AbstractPointGenerator {
    private static final String PERFORMANCE_ERROR_PERCENT = "error_percent";
    private static final String PERFORMANCE_ERROR_COUNT = "error_count";
    private static final String PERFORMANCE_AVERAGE = "average";
    private static final String PERFORMANCE_90PERCENTILE = "90Percentile";
    private static final String PERFORMANCE_MEDIAN = "median";
    private static final String PERFORMANCE_MAX = "max";
    private static final String PERFORMANCE_MIN = "min";
    private static final String PERFORMANCE_TOTAL_TRAFFIC = "total_traffic";
    private static final String PERFORMANCE_SIZE = "size";
    private final Run<?, ?> build;
    private final String customPrefix;
    private final PerformanceBuildAction performanceBuildAction;

    public PerformancePointGenerator(MeasurementRenderer<Run<?, ?>> measurementRenderer, String customPrefix, Run<?, ?> build, long timestamp, boolean replaceDashWithUnderscore) {
        super(measurementRenderer, timestamp, replaceDashWithUnderscore);
        this.build = build;
        this.customPrefix = customPrefix;
        this.performanceBuildAction = (PerformanceBuildAction)build.getAction(PerformanceBuildAction.class);
    }

    @Override
    public boolean hasReport() {
        return this.performanceBuildAction != null && this.performanceBuildAction.getPerformanceReportMap() != null;
    }

    @Override
    public Point[] generate() {
        Map reportMap = this.performanceBuildAction.getPerformanceReportMap().getPerformanceReportMap();
        ArrayList<Point> pointsList = new ArrayList<Point>();
        for (PerformanceReport report : reportMap.values()) {
            pointsList.add(this.generateReportPoint(report));
        }
        return pointsList.toArray(new Point[0]);
    }

    private Point generateReportPoint(PerformanceReport performanceReport) {
        Point point = this.buildPoint(this.measurementName("performance_data"), this.customPrefix, this.build).addField(PERFORMANCE_ERROR_PERCENT, performanceReport.errorPercent()).addField(PERFORMANCE_ERROR_COUNT, (long)performanceReport.countErrors()).addField(PERFORMANCE_AVERAGE, performanceReport.getAverage()).addField(PERFORMANCE_MAX, performanceReport.getMax()).addField(PERFORMANCE_MIN, performanceReport.getMin()).addField(PERFORMANCE_TOTAL_TRAFFIC, performanceReport.getTotalTrafficInKb()).addField(PERFORMANCE_SIZE, (long)performanceReport.samplesCount()).addField(PERFORMANCE_90PERCENTILE, performanceReport.get90Line()).addField(PERFORMANCE_MEDIAN, performanceReport.getMedian()).build();
        return point;
    }
}

