/*
 * Decompiled with CFR 0.152.
 */
package jenkinsci.plugins.influxdb.generators;

import hudson.model.Run;
import java.util.ArrayList;
import java.util.Map;
import jenkinsci.plugins.influxdb.generators.AbstractPointGenerator;
import jenkinsci.plugins.influxdb.renderer.MeasurementRenderer;
import org.influxdb.dto.Point;

public class CustomDataMapPointGenerator
extends AbstractPointGenerator {
    private final Run<?, ?> build;
    private final String customPrefix;
    private final Map<String, Map<String, Object>> customDataMap;
    private final Map<String, Map<String, String>> customDataMapTags;

    public CustomDataMapPointGenerator(MeasurementRenderer<Run<?, ?>> projectNameRenderer, String customPrefix, Run<?, ?> build, long timestamp, Map<String, Map<String, Object>> customDataMap, Map<String, Map<String, String>> customDataMapTags, boolean replaceDashWithUnderscore) {
        super(projectNameRenderer, timestamp, replaceDashWithUnderscore);
        this.build = build;
        this.customPrefix = customPrefix;
        this.customDataMap = customDataMap;
        this.customDataMapTags = customDataMapTags;
    }

    @Override
    public boolean hasReport() {
        return this.customDataMap != null && this.customDataMap.size() > 0;
    }

    @Override
    public Point[] generate() {
        ArrayList<Point> customPoints = new ArrayList<Point>();
        for (Map.Entry<String, Map<String, Object>> entry : this.customDataMap.entrySet()) {
            Map<String, String> customTags;
            Point.Builder pointBuilder = this.buildPoint(this.measurementName(entry.getKey()), this.customPrefix, this.build).fields(entry.getValue());
            if (this.customDataMapTags != null && (customTags = this.customDataMapTags.get(entry.getKey())) != null && customTags.size() > 0) {
                pointBuilder.tag(customTags);
            }
            Point point = pointBuilder.build();
            customPoints.add(point);
        }
        return customPoints.toArray(new Point[0]);
    }
}

