/*
 * Decompiled with CFR 0.152.
 */
package jenkinsci.plugins.influxdb.generators;

import hudson.model.ItemGroup;
import hudson.model.Run;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import jenkins.model.Jenkins;
import jenkinsci.plugins.influxdb.generators.PointGenerator;
import jenkinsci.plugins.influxdb.renderer.MeasurementRenderer;
import org.influxdb.dto.Point;

public abstract class AbstractPointGenerator
implements PointGenerator {
    public static final String PROJECT_NAME = "project_name";
    public static final String PROJECT_PATH = "project_path";
    public static final String BUILD_NUMBER = "build_number";
    public static final String CUSTOM_PREFIX = "prefix";
    public long timestamp;
    public boolean replaceDashWithUnderscore;
    private MeasurementRenderer projectNameRenderer;

    public AbstractPointGenerator(MeasurementRenderer projectNameRenderer, long timestamp, boolean replaceDashWithUnderscore) {
        this.projectNameRenderer = Objects.requireNonNull(projectNameRenderer);
        this.timestamp = timestamp;
        this.replaceDashWithUnderscore = replaceDashWithUnderscore;
    }

    @Override
    public Point.Builder buildPoint(String name, String customPrefix, Run<?, ?> build, long timestamp) {
        String renderedProjectName = this.projectNameRenderer.render(build);
        String projectTagName = this.replaceDashWithUnderscore ? renderedProjectName : customPrefix + "_" + build.getParent().getName();
        Point.Builder builder = Point.measurement((String)name).addField(PROJECT_NAME, renderedProjectName).addField(PROJECT_PATH, build.getParent().getRelativeNameFrom((ItemGroup)Jenkins.getInstance())).addField(BUILD_NUMBER, (long)build.getNumber()).time(timestamp, TimeUnit.NANOSECONDS);
        if (customPrefix != null && !customPrefix.isEmpty()) {
            builder.tag(CUSTOM_PREFIX, this.replaceDashWithUnderscore ? this.measurementName(customPrefix) : customPrefix);
        }
        builder.tag(PROJECT_NAME, projectTagName);
        return builder;
    }

    @Override
    public Point.Builder buildPoint(String name, String customPrefix, Run<?, ?> build) {
        return this.buildPoint(name, customPrefix, build, this.timestamp);
    }

    protected String measurementName(String measurement) {
        return measurement.replaceAll("-", "_");
    }
}

