/*
 * Decompiled with CFR 0.152.
 */
package jenkinsci.plugins.influxdb;

import com.google.common.base.Preconditions;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Notifier;
import hudson.tasks.Publisher;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;
import jenkins.tasks.SimpleBuildStep;
import jenkinsci.plugins.influxdb.DescriptorImpl;
import jenkinsci.plugins.influxdb.InfluxDbPublicationService;
import jenkinsci.plugins.influxdb.models.Target;
import okhttp3.Authenticator;
import okhttp3.Credentials;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.Route;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class InfluxDbPublisher
extends Notifier
implements SimpleBuildStep {
    private static final Logger logger = Logger.getLogger(InfluxDbPublisher.class.getName());
    public static final String DEFAULT_MEASUREMENT_NAME = "jenkins_data";
    @Extension(optional=true)
    public static final DescriptorImpl DESCRIPTOR = new DescriptorImpl();
    private String selectedTarget;
    private String customProjectName;
    private String customPrefix;
    private String jenkinsEnvParameterField;
    private String jenkinsEnvParameterTag;
    private Map<String, Object> customData;
    private Map<String, String> customDataTags;
    private Map<String, Map<String, Object>> customDataMap;
    private Map<String, Map<String, String>> customDataMapTags;
    private String measurementName;
    private boolean replaceDashWithUnderscore;

    @DataBoundConstructor
    public InfluxDbPublisher() {
    }

    public InfluxDbPublisher(String target) {
        this.selectedTarget = target;
    }

    public String getSelectedTarget() {
        Target[] targets;
        String ipTemp = this.selectedTarget;
        if (ipTemp == null && (targets = DESCRIPTOR.getTargets()).length > 0) {
            ipTemp = targets[0].getDescription();
        }
        return ipTemp;
    }

    @DataBoundSetter
    public void setSelectedTarget(String target) {
        Preconditions.checkNotNull((Object)target);
        this.selectedTarget = target;
    }

    public String getCustomProjectName() {
        return this.customProjectName;
    }

    @DataBoundSetter
    public void setCustomProjectName(String customProjectName) {
        this.customProjectName = customProjectName;
    }

    public String getCustomPrefix() {
        return this.customPrefix;
    }

    @DataBoundSetter
    public void setCustomPrefix(String customPrefix) {
        this.customPrefix = customPrefix;
    }

    public String getJenkinsEnvParameterField() {
        return this.jenkinsEnvParameterField;
    }

    @DataBoundSetter
    public void setJenkinsEnvParameterField(String jenkinsEnvParameterField) {
        this.jenkinsEnvParameterField = jenkinsEnvParameterField;
    }

    public String getJenkinsEnvParameterTag() {
        return this.jenkinsEnvParameterTag;
    }

    @DataBoundSetter
    public void setJenkinsEnvParameterTag(String jenkinsEnvParameterTag) {
        this.jenkinsEnvParameterTag = jenkinsEnvParameterTag;
    }

    @DataBoundSetter
    public void setCustomData(Map<String, Object> customData) {
        this.customData = customData;
    }

    public Map<String, Object> getCustomData() {
        return this.customData;
    }

    @DataBoundSetter
    public void setCustomDataTags(Map<String, String> customDataTags) {
        this.customDataTags = customDataTags;
    }

    public Map<String, String> getCustomDataTags() {
        return this.customDataTags;
    }

    @DataBoundSetter
    public void setCustomDataMap(Map<String, Map<String, Object>> customDataMap) {
        this.customDataMap = customDataMap;
    }

    public Map<String, Map<String, Object>> getCustomDataMap() {
        return this.customDataMap;
    }

    @DataBoundSetter
    public void setCustomDataMapTags(Map<String, Map<String, String>> customDataMapTags) {
        this.customDataMapTags = customDataMapTags;
    }

    public Map<String, Map<String, String>> getCustomDataMapTags() {
        return this.customDataMapTags;
    }

    @DataBoundSetter
    public void setMeasurementName(String measurementName) {
        this.measurementName = measurementName;
    }

    public boolean getReplaceDashWithUnderscore() {
        return this.replaceDashWithUnderscore;
    }

    @DataBoundSetter
    public void setReplaceDashWithUnderscore(boolean replaceDashWithUnderscore) {
        this.replaceDashWithUnderscore = replaceDashWithUnderscore;
    }

    public String getMeasurementName() {
        return this.measurementName;
    }

    private String getMeasurementNameIfNotBlankOrDefault() {
        return this.measurementName != null ? this.measurementName : DEFAULT_MEASUREMENT_NAME;
    }

    public Target getTarget() {
        Target[] targets = DESCRIPTOR.getTargets();
        if (this.selectedTarget == null && targets.length > 0) {
            return targets[0];
        }
        for (Target target : targets) {
            String targetInfo = target.getDescription();
            if (!targetInfo.equals(this.selectedTarget)) continue;
            return target;
        }
        return null;
    }

    public boolean prebuild(Run<?, ?> build, TaskListener listener) {
        return true;
    }

    public boolean needsToRunAfterFinalized() {
        return true;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    public BuildStepDescriptor<Publisher> getDescriptor() {
        return DESCRIPTOR;
    }

    public void perform(@Nonnull Run<?, ?> build, @Nonnull FilePath workspace, @Nonnull Launcher launcher, @Nonnull TaskListener listener) throws InterruptedException, IOException {
        Target target = this.getTarget();
        if (target == null) {
            throw new RuntimeException("Target was null!");
        }
        long currTime = this.resolveTimestampForPointGenerationInNanoseconds(build);
        this.measurementName = this.getMeasurementNameIfNotBlankOrDefault();
        InfluxDbPublicationService publicationService = new InfluxDbPublicationService(Collections.singletonList(target), this.customProjectName, this.customPrefix, this.customData, this.customDataTags, this.customDataMapTags, this.customDataMap, currTime, this.jenkinsEnvParameterField, this.jenkinsEnvParameterTag, this.measurementName, this.replaceDashWithUnderscore);
        OkHttpClient.Builder builder = new OkHttpClient.Builder();
        if (target.isUsingJenkinsProxy()) {
            builder.proxy(Jenkins.getInstance().proxy.createProxy(target.getUrl()));
            if (Jenkins.getInstance().proxy.getUserName() != null) {
                builder.proxyAuthenticator(new Authenticator(){

                    public Request authenticate(Route route, Response response) throws IOException {
                        if (response.request().header("Proxy-Authorization") != null) {
                            return null;
                        }
                        String credential = Credentials.basic((String)Jenkins.getInstance().proxy.getUserName(), (String)Jenkins.getInstance().proxy.getPassword());
                        return response.request().newBuilder().header("Proxy-Authorization", credential).build();
                    }
                });
            }
            builder.build();
        }
        publicationService.perform(build, listener);
    }

    private long resolveTimestampForPointGenerationInNanoseconds(Run<?, ?> build) {
        long timestamp = System.currentTimeMillis();
        if (this.getTarget().isJobScheduledTimeAsPointsTimestamp()) {
            timestamp = build.getTimeInMillis();
        }
        return timestamp * 1000000L;
    }
}

