/*
 * Decompiled with CFR 0.152.
 */
package com.kagilum.plugins.icescrum;

import com.kagilum.plugins.icescrum.IceScrumProjectSettings;
import com.kagilum.plugins.icescrum.Messages;
import hudson.util.IOUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.json.JSONObject;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.HttpStatus;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;

public class IceScrumSession {
    public static final int BUILD_SUCCESS = 1;
    public static final int BUILD_FAILURE = 5;
    public static final int BUILD_ERROR = 10;
    public static final float REQUIRED_VERSION = 6.06f;
    public static final String TASK_PATTERN = "T(\\d+)-?(\\d+\\.\\d+|\\d+\\,\\d+|\\d+)?";
    private IceScrumProjectSettings settings;
    private HttpClient client;
    private String httpError = null;
    private String body;
    private static final Logger LOGGER = Logger.getLogger(IceScrumSession.class.getName());

    public IceScrumSession(IceScrumProjectSettings settings) {
        this.settings = settings;
        this.initClient();
    }

    public boolean isConnect() {
        GetMethod method = new GetMethod(this.settings.getUrl() + "/version/");
        if (this.executeMethod(method)) {
            try {
                String version = this.body;
                if (version.isEmpty()) {
                    throw new IOException(Messages.IceScrumSession_icescrum_http_notfound());
                }
                if (version.startsWith("7.")) {
                    method = new GetMethod(this.settings.getUrl() + this.settings.getPath() + this.settings.getPkey() + "/build/jenkins");
                    return this.executeMethod(method, 200);
                }
                if (!version.contains("Pro")) {
                    throw new IOException(Messages.IceScrumSession_only_pro_version());
                }
                if ((version = version.replaceAll(" Pro", "").replaceAll(" Cloud", "").replaceAll("R", "").replaceAll("\\.", "").replaceAll("#", ".")).length() == 3) {
                    version = version.replaceAll("\\.", ".0");
                }
                if (Float.parseFloat(version) < 6.06f) {
                    throw new IOException(Messages.IceScrumSession_not_compatible_version());
                }
                method = new GetMethod(this.settings.getUrl() + this.settings.getPath() + this.settings.getPkey() + "/task");
                return this.executeMethod(method);
            }
            catch (IOException e) {
                this.httpError = e.getMessage();
            }
        }
        return false;
    }

    public boolean sendBuildStatut(JSONObject build) throws UnsupportedEncodingException {
        PostMethod method = new PostMethod(this.settings.getUrl() + this.settings.getPath() + this.settings.getPkey() + "/" + (this.settings.isTokenAuth() ? "build/jenkins" : "build"));
        StringRequestEntity requestEntity = new StringRequestEntity(build.toString(), "application/json", "UTF-8");
        method.setRequestEntity((RequestEntity)requestEntity);
        return this.executeMethod(method, 201);
    }

    private void initClient() {
        this.client = new HttpClient();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean executeMethod(PostMethod method, int expectedCode) {
        boolean result = false;
        try {
            this.setAuthentication((HttpMethodBase)method);
            this.client.executeMethod((HttpMethod)method);
            int code = method.getStatusCode();
            if (code != 200 && expectedCode != 0 && expectedCode != code) {
                this.checkServerStatus(code);
            } else {
                this.body = IOUtils.toString((InputStream)method.getResponseBodyAsStream());
                result = true;
            }
        }
        catch (IOException e) {
            this.httpError = e.getMessage();
            LOGGER.log(Level.WARNING, this.httpError, e);
        }
        finally {
            method.releaseConnection();
        }
        return result;
    }

    private boolean executeMethod(GetMethod method) {
        return this.executeMethod(method, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean executeMethod(GetMethod method, int expectedCode) {
        boolean result = false;
        try {
            this.setAuthentication((HttpMethodBase)method);
            method.setRequestHeader("accept", "application/json");
            this.client.executeMethod((HttpMethod)method);
            int code = method.getStatusCode();
            if (code != 200 && expectedCode != 0 && expectedCode != code) {
                this.checkServerStatus(code);
            } else {
                this.body = IOUtils.toString((InputStream)method.getResponseBodyAsStream());
                result = true;
            }
        }
        catch (IOException e) {
            this.httpError = e.getMessage();
            LOGGER.log(Level.WARNING, this.httpError, e);
        }
        finally {
            method.releaseConnection();
        }
        return result;
    }

    private void setAuthentication(HttpMethodBase method) throws MalformedURLException {
        URL url = new URL(this.settings.getUrl() + "/version/");
        int port = url.getPort() == -1 ? url.getDefaultPort() : url.getPort();
        if (this.settings.isTokenAuth()) {
            method.setRequestHeader("content-type", "application/json");
            method.setRequestHeader("x-icescrum-token", this.settings.getAccessToken());
        } else {
            this.client.getState().setCredentials(new AuthScope(url.getHost(), port), (Credentials)new UsernamePasswordCredentials(this.settings.getUsername(), this.settings.getPassword()));
        }
    }

    private void checkServerStatus(int code) throws IOException {
        switch (code) {
            case 503: {
                throw new IOException(this.settings.isTokenAuth() ? Messages.IceScrumSession_icescrum_http_unavailable_new() : Messages.IceScrumSession_icescrum_http_unavailable());
            }
            case 401: {
                throw new IOException(Messages.IceScrumSession_icescrum_http_unauthorized());
            }
            case 403: {
                throw new IOException(Messages.IceScrumSession_icescrum_http_forbidden());
            }
            case 404: {
                throw new IOException(Messages.IceScrumSession_icescrum_http_notfound());
            }
        }
        throw new IOException(Messages.IceScrumSession_icescrum_http_error() + " (" + HttpStatus.getStatusText((int)code) + ")");
    }

    public String getLastError() {
        return this.httpError != null ? this.httpError : "";
    }
}

