/*
 * Decompiled with CFR 0.152.
 */
package com.kagilum.plugins.icescrum;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class IceScrumProjectSettings {
    public static final String AUTH_TYPE_TOKEN = "token";
    public static final String AUTH_TYPE_BASIC = "basic";
    private String url;
    private String pkey;
    private String authType = "token";
    private String username = null;
    private String password = null;
    private String accessToken = null;
    private static final String PATTERN_ICESCRUM_URL = "(http|https)://(.*)/p/([0-9A-Z]*)";

    public IceScrumProjectSettings(String url) {
        Pattern pattern = Pattern.compile(PATTERN_ICESCRUM_URL);
        Matcher matches = pattern.matcher(url);
        if (matches.matches()) {
            this.url = matches.group(1) + "://" + matches.group(2);
            this.pkey = matches.group(3);
        }
    }

    public IceScrumProjectSettings(String url, String accessToken) {
        this(url);
        this.authType = AUTH_TYPE_TOKEN;
        this.accessToken = accessToken;
    }

    public IceScrumProjectSettings(String url, String username, String password) {
        this(url);
        this.authType = AUTH_TYPE_BASIC;
        this.username = username;
        this.password = password;
    }

    public String getAuthType() {
        return this.authType;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPkey() {
        return this.pkey;
    }

    public String getUrl() {
        return this.url;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public String getPassword() {
        return this.password;
    }

    public String getProjectUrl() {
        return this.url + "/p/" + this.pkey;
    }

    public boolean hasAuth() {
        if (this.authType.equals(AUTH_TYPE_BASIC)) {
            return this.password != null && this.username != null;
        }
        return this.accessToken != null;
    }

    public String getPath() {
        return this.isTokenAuth() ? "/ws/project/" : "/ws/p/";
    }

    public boolean isTokenAuth() {
        return this.authType.equals(AUTH_TYPE_TOKEN);
    }

    public static boolean isValidUrl(String url) {
        Pattern pattern = Pattern.compile(PATTERN_ICESCRUM_URL);
        Matcher matches = pattern.matcher(url);
        return matches.matches();
    }
}

