/*
 * Decompiled with CFR 0.152.
 */
package com.kagilum.plugins.icescrum;

import com.kagilum.plugins.icescrum.IceScrumLinkAction;
import com.kagilum.plugins.icescrum.IceScrumProjectSettings;
import com.kagilum.plugins.icescrum.IceScrumSession;
import com.kagilum.plugins.icescrum.Messages;
import hudson.Extension;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Descriptor;
import hudson.model.Job;
import hudson.model.JobProperty;
import hudson.model.JobPropertyDescriptor;
import hudson.util.FormValidation;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import javax.servlet.ServletException;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

public final class IceScrumProjectProperty
extends JobProperty<AbstractProject<?, ?>> {
    private IceScrumProjectSettings settings;

    @DataBoundConstructor
    public IceScrumProjectProperty(String url, String username, String password, String accessToken, String authType) {
        this.settings = username != null && password != null && authType != null && authType.equals("basic") ? new IceScrumProjectSettings(url, username, password) : (accessToken != null && authType != null && authType.equals("token") ? new IceScrumProjectSettings(url, accessToken) : new IceScrumProjectSettings(url));
    }

    public IceScrumProjectSettings getSettings() {
        return this.settings;
    }

    public Collection<? extends Action> getJobActions(AbstractProject<?, ?> job) {
        if (this.settings != null) {
            return Collections.singleton(new IceScrumLinkAction(this));
        }
        return Collections.emptyList();
    }

    @Extension
    public static final class DescriptorImpl
    extends JobPropertyDescriptor {
        public DescriptorImpl() {
            super(IceScrumProjectProperty.class);
            this.load();
        }

        public boolean isApplicable(Class<? extends Job> jobType) {
            return AbstractProject.class.isAssignableFrom(jobType);
        }

        public String getDisplayName() {
            return Messages.IceScrumProjectProperty_icescrum_projectProperty_displayName();
        }

        public FormValidation doCheckUrl(@QueryParameter String value) {
            if (IceScrumProjectSettings.isValidUrl(value)) {
                return FormValidation.ok();
            }
            return FormValidation.error((String)Messages.IceScrumProjectProperty_icescrum_error_url());
        }

        public FormValidation doLoginCheck(@QueryParameter(value="icescrum.accessToken") String accessToken, @QueryParameter(value="icescrum.url") String url) throws IOException, ServletException {
            if (!IceScrumProjectSettings.isValidUrl(url)) {
                return FormValidation.error((String)Messages.IceScrumProjectProperty_icescrum_error_url());
            }
            if (StringUtils.isEmpty((String)accessToken) || StringUtils.isEmpty((String)url)) {
                return FormValidation.error((String)Messages.IceScrumProjectProperty_icescrum_parameters_missing());
            }
            IceScrumProjectSettings settings = new IceScrumProjectSettings(url, accessToken);
            IceScrumSession session = new IceScrumSession(settings);
            if (!session.isConnect()) {
                return FormValidation.ok((String)session.getLastError());
            }
            return FormValidation.ok((String)Messages.IceScrumProjectProperty_icescrum_connection_successful());
        }

        public FormValidation doOldLoginCheck(@QueryParameter(value="icescrum.username") String username, @QueryParameter(value="icescrum.password") String password, @QueryParameter(value="icescrum.url") String url) throws IOException, ServletException {
            if (!IceScrumProjectSettings.isValidUrl(url)) {
                return FormValidation.error((String)Messages.IceScrumProjectProperty_icescrum_error_url());
            }
            if (StringUtils.isEmpty((String)username) || StringUtils.isEmpty((String)password) || StringUtils.isEmpty((String)url)) {
                return FormValidation.error((String)Messages.IceScrumProjectProperty_icescrum_parameters_missing());
            }
            IceScrumProjectSettings settings = new IceScrumProjectSettings(url, username, password);
            IceScrumSession session = new IceScrumSession(settings);
            if (!session.isConnect()) {
                return FormValidation.ok((String)session.getLastError());
            }
            return FormValidation.ok((String)Messages.IceScrumProjectProperty_icescrum_connection_successful());
        }

        public JobProperty<?> newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            if (req != null) {
                IceScrumProjectProperty ipp = (IceScrumProjectProperty)((Object)req.bindJSON(IceScrumProjectProperty.class, formData));
                if (ipp.getSettings() == null) {
                    ipp = null;
                }
                return ipp;
            }
            return null;
        }
    }
}

