/*
 * Decompiled with CFR 0.152.
 */
package com.kagilum.plugins.icescrum;

import com.kagilum.plugins.icescrum.IceScrumProjectProperty;
import com.kagilum.plugins.icescrum.Messages;
import hudson.Extension;
import hudson.MarkupText;
import hudson.model.AbstractBuild;
import hudson.scm.ChangeLogAnnotator;
import hudson.scm.ChangeLogSet;
import java.util.regex.Pattern;

@Extension
public class IceScrumLinkAnnotator
extends ChangeLogAnnotator {
    public void annotate(AbstractBuild<?, ?> abstractBuild, ChangeLogSet.Entry change, MarkupText markupText) {
        IceScrumProjectProperty p = (IceScrumProjectProperty)abstractBuild.getProject().getProperty(IceScrumProjectProperty.class);
        if (null == p || null == p.getSettings()) {
            return;
        }
        this.annotate(p.getSettings().getProjectUrl(), markupText);
    }

    public void annotate(String url, MarkupText text) {
        for (MarkupText.SubText st : text.findTokens(Pattern.compile("T(\\d+)-?(\\d+\\.\\d+|\\d+\\,\\d+|\\d+)?"))) {
            String detailsI18n;
            if (st.group(2) == null) {
                detailsI18n = Messages.IceScrumLinkAnnotator_icescrum_link_details();
                st.surroundWith("<a href='" + url + "-T$1' title='" + detailsI18n + "'>", "</a>");
                continue;
            }
            detailsI18n = Messages.IceScrumLinkAnnotator_icescrum_link_details_time();
            st.surroundWith("<a href='" + url + "-T$1' title='" + detailsI18n + "'>", "</a>");
        }
    }
}

