/*
 * Decompiled with CFR 0.152.
 */
package com.kagilum.plugins.icescrum;

import com.kagilum.plugins.icescrum.IceScrumProjectProperty;
import com.kagilum.plugins.icescrum.IceScrumSession;
import com.kagilum.plugins.icescrum.Messages;
import hudson.Extension;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Hudson;
import hudson.model.Result;
import hudson.scm.ChangeLogSet;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Notifier;
import hudson.tasks.Publisher;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;

public class IceScrumBuildNotifier
extends Notifier {
    @DataBoundConstructor
    public IceScrumBuildNotifier() {
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        JSONObject jsonRoot;
        IceScrumProjectProperty p = (IceScrumProjectProperty)build.getProject().getProperty(IceScrumProjectProperty.class);
        if (null == p || null == p.getSettings() || !p.getSettings().hasAuth()) {
            return true;
        }
        IceScrumSession session = new IceScrumSession(p.getSettings());
        if (session.sendBuildStatut(jsonRoot = this.createIceScrumBuildObject(build, listener, "T(\\d+)-?(\\d+\\.\\d+|\\d+\\,\\d+|\\d+)?", !p.getSettings().isTokenAuth()))) {
            listener.getLogger().println(Messages.IceScrumBuildNotifier_icescrum_build_success() + p.getSettings().getProjectUrl() + ")");
        } else {
            listener.getLogger().println(Messages.IceScrumBuildNotifier_icescrum_build_error() + p.getSettings().getProjectUrl() + Messages.IceScrumBuildNotifier_icescrum_build_error_check());
        }
        return true;
    }

    public JSONObject createIceScrumBuildObject(AbstractBuild<?, ?> build, BuildListener listener, String pattern, boolean includeBuiltOn) {
        Result result;
        Hudson instance = Hudson.getInstance();
        String jobUrl = instance != null ? instance.getRootUrl() + build.getUrl() : "";
        JSONObject jsonData = new JSONObject();
        JSONObject jsonBuild = new JSONObject();
        jsonBuild.element("jobName", (Object)build.getProject().getDisplayName());
        jsonBuild.element("name", (Object)build.getDisplayName());
        jsonBuild.element("number", build.getNumber());
        jsonBuild.element("date", build.getTimeInMillis());
        jsonBuild.element("url", (Object)jobUrl);
        if (includeBuiltOn) {
            jsonBuild.element("builtOn", (Object)("Jenkins: " + build.getHudsonVersion()));
        }
        if ((result = build.getResult()) != null) {
            if (result.isBetterOrEqualTo(Result.SUCCESS)) {
                jsonBuild.element("status", 1);
            } else if (result.isBetterOrEqualTo(Result.UNSTABLE)) {
                jsonBuild.element("status", 5);
            } else {
                jsonBuild.element("status", 10);
            }
        } else {
            jsonBuild.element("status", 10);
        }
        ArrayList<Integer> ids = new ArrayList<Integer>();
        if (!build.getChangeSet().isEmptySet()) {
            for (ChangeLogSet.Entry change : build.getChangeSet()) {
                Matcher m = Pattern.compile(pattern).matcher(change.getMsg());
                while (m.find()) {
                    if (m.groupCount() < 1) continue;
                    ids.add(Integer.parseInt(m.group(1)));
                }
            }
            jsonBuild.element("tasks", ids);
        }
        if (ids.size() == 0) {
            listener.getLogger().println(Messages.IceScrumBuildNotifier_icescrum_build_empty());
        }
        jsonData.element("build", (Map)jsonBuild);
        return jsonData;
    }

    @Extension
    public static class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return true;
        }

        public String getDisplayName() {
            return Messages.IceScrumBuildNotifier_icescrum_notifier_displayName();
        }
    }
}

