/*
 * Decompiled with CFR 0.152.
 */
package com.cwctravel.jenkinsci.plugins.htmlresource.config;

import com.cwctravel.jenkinsci.plugins.htmlresource.HTMLResourceManagement;
import com.cwctravel.jenkinsci.plugins.htmlresource.config.HTMLResource;
import com.cwctravel.jenkinsci.plugins.htmlresource.config.HTMLResourceEntry;
import com.cwctravel.jenkinsci.plugins.htmlresource.config.HTMLResourceSet;
import com.cwctravel.jenkinsci.plugins.htmlresource.config.NamedResource;
import com.cwctravel.jenkinsci.plugins.htmlresource.util.ByIdSorter;
import com.thoughtworks.xstream.XStream;
import hudson.BulkChange;
import hudson.XmlFile;
import hudson.model.Saveable;
import hudson.model.listeners.SaveableListener;
import hudson.util.XStream2;
import java.io.File;
import java.io.IOException;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class HTMLResourceConfiguration
extends HTMLResourceSet
implements Saveable {
    private static final Logger LOGGER = Logger.getLogger(HTMLResourceConfiguration.class.getName());
    private static transient HTMLResourceConfiguration cfg = null;
    private static final XStream XSTREAM = new XStream2();

    public HTMLResourceConfiguration(SortedSet<HTMLResource> scripts) {
        if (scripts != null) {
            this.htmlResourceSet = scripts;
        }
    }

    public synchronized void save() throws IOException {
        if (BulkChange.contains((Saveable)this)) {
            return;
        }
        HTMLResourceConfiguration.getXmlFile().write((Object)this);
        SaveableListener.fireOnChange((Saveable)this, (XmlFile)HTMLResourceConfiguration.getXmlFile());
    }

    public static XmlFile getXmlFile() {
        return new XmlFile(XSTREAM, new File(HTMLResourceManagement.getHTMLResourceHomeDirectory(), "htmlresource.xml"));
    }

    public static HTMLResourceConfiguration load() throws IOException {
        XmlFile f = HTMLResourceConfiguration.getXmlFile();
        if (f.exists()) {
            HTMLResourceConfiguration sc = (HTMLResourceConfiguration)f.read();
            TreeSet<NamedResource> sorted = new TreeSet<NamedResource>(new ByIdSorter());
            sorted.addAll(sc.getHTMLResources());
            sc.setHTMLResources(sorted);
            return sc;
        }
        return null;
    }

    public static synchronized HTMLResourceConfiguration getConfiguration() {
        if (cfg == null) {
            try {
                cfg = HTMLResourceConfiguration.load();
            }
            catch (IOException e) {
                LOGGER.log(Level.SEVERE, "Failed to load htmlresource configuration", e);
            }
        }
        return cfg;
    }

    static {
        XSTREAM.alias("htmlResourceConfig", HTMLResourceConfiguration.class);
        XSTREAM.alias("htmlResource", HTMLResource.class);
        XSTREAM.alias("htmlResourceEntry", HTMLResourceEntry.class);
    }
}

