/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.nvemulation.plugin.results;

import org.jdom2.Content;
import org.jdom2.Element;
import org.jenkinsci.plugins.nvemulation.plugin.results.NvTestCaseResult;

public class XmlTestCaseElementCreator {
    public static Element create(String className, String profileName, NvTestCaseResult testCaseResult) {
        Element element = new Element("testcase");
        element.setAttribute("name", testCaseResult.getName() + "_" + profileName.replace(" ", ""));
        element.setAttribute("classname", className);
        element.setAttribute("time", String.valueOf(testCaseResult.getDuration()));
        if (testCaseResult.isSkipped()) {
            element.addContent((Content)XmlTestCaseElementCreator.createSkipped());
        } else if (testCaseResult.isFail()) {
            element.addContent((Content)XmlTestCaseElementCreator.createFailure(testCaseResult));
        } else if (testCaseResult.isError()) {
            element.addContent((Content)XmlTestCaseElementCreator.createError(testCaseResult));
        }
        return element;
    }

    private static Element createSkipped() {
        return new Element("skipped");
    }

    private static Element createFailure(NvTestCaseResult testCaseResult) {
        Element element = new Element("failure");
        element.setAttribute("message", testCaseResult.getErrorMessage());
        element.setAttribute("type", XmlTestCaseElementCreator.extractErrorType(testCaseResult.getErrorStackTrace()));
        element.setText(testCaseResult.getErrorStackTrace());
        return element;
    }

    private static Element createError(NvTestCaseResult testCaseResult) {
        Element element = new Element("error");
        element.setAttribute("message", testCaseResult.getErrorMessage());
        element.setAttribute("type", XmlTestCaseElementCreator.extractErrorType(testCaseResult.getErrorStackTrace()));
        element.setText(testCaseResult.getErrorStackTrace());
        return element;
    }

    private static String extractErrorType(String errorStack) {
        if (null != errorStack && !errorStack.isEmpty()) {
            return errorStack.substring(0, errorStack.indexOf(":"));
        }
        return "";
    }
}

