/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.nvemulation.plugin.results;

import hudson.tasks.junit.CaseResult;
import hudson.tasks.junit.SuiteResult;
import hudson.tasks.junit.TestResult;
import java.util.Map;
import org.jenkinsci.plugins.nvemulation.model.NvNetworkProfile;
import org.jenkinsci.plugins.nvemulation.plugin.results.NvClassResult;
import org.jenkinsci.plugins.nvemulation.plugin.results.NvJUnitResult;
import org.jenkinsci.plugins.nvemulation.plugin.results.NvProfileResult;
import org.jenkinsci.plugins.nvemulation.plugin.results.NvTestCaseResult;
import org.jenkinsci.plugins.nvemulation.plugin.results.NvTestSuiteResult;

public class NvResultsBuilder {
    private static final String ERROR_MESSAGE = "Failed by HPE Network Virtualization. Reason: duration (%s) > threshold (%s)";
    private static final String ASSERTION_EXCEPTION_CLASS_NAME = AssertionError.class.getName();
    private Map<String, Float> thresholdsMap;
    private NvJUnitResult result = new NvJUnitResult();
    private boolean finalized;

    public NvResultsBuilder(Map<String, Float> thresholdsMap) {
        this.thresholdsMap = thresholdsMap;
    }

    public void aggregate(TestResult testResult, NvNetworkProfile profile) {
        this.result.getProfiles().add(profile.toDTO());
        for (SuiteResult suiteResult : testResult.getSuites()) {
            for (CaseResult caseResult : suiteResult.getCases()) {
                NvTestCaseResult testCaseResult = new NvTestCaseResult(caseResult.getName());
                testCaseResult.setDuration(caseResult.getDuration());
                Float threshold = this.getThreshold(caseResult.getClassName(), caseResult.getName());
                if (null != threshold && caseResult.isPassed()) {
                    testCaseResult.setThreshold(threshold.floatValue());
                    if (caseResult.getDuration() > threshold.floatValue()) {
                        testCaseResult.setFailed();
                        testCaseResult.setErrorMessage(String.format(ERROR_MESSAGE, Float.valueOf(caseResult.getDuration()), threshold));
                        testCaseResult.setErrorStackTrace("");
                    } else {
                        testCaseResult.setPassed();
                    }
                } else if (caseResult.isFailed()) {
                    if (this.checkFailedException(caseResult.getErrorStackTrace())) {
                        testCaseResult.setFailed();
                    } else {
                        testCaseResult.setError();
                    }
                    testCaseResult.setErrorMessage(caseResult.getErrorDetails());
                    testCaseResult.setErrorStackTrace(caseResult.getErrorStackTrace());
                } else if (caseResult.isSkipped()) {
                    testCaseResult.setSkipped();
                } else {
                    testCaseResult.setPassed();
                }
                NvProfileResult profileResult = this.getTestCaseParent(suiteResult.getName(), caseResult.getClassName(), profile.getProfileName());
                profileResult.addResult(testCaseResult);
            }
        }
    }

    public NvJUnitResult finalizeResults() {
        if (!this.finalized) {
            this.result.tally();
            this.finalized = true;
        }
        return this.result;
    }

    private NvProfileResult getTestCaseParent(String testSuiteName, String className, String profileName) {
        NvTestSuiteResult nvTestSuiteResult = this.result.getNvTestSuiteResult(testSuiteName);
        if (null == nvTestSuiteResult) {
            nvTestSuiteResult = new NvTestSuiteResult(testSuiteName);
            this.result.addNvTestSuiteResult(nvTestSuiteResult);
            NvClassResult nvClassResult = new NvClassResult(className);
            nvTestSuiteResult.addResult(nvClassResult);
            NvProfileResult nvProfileResult = new NvProfileResult(profileName);
            nvClassResult.addResult(nvProfileResult);
            return nvProfileResult;
        }
        NvClassResult nvClassResult = (NvClassResult)nvTestSuiteResult.getResult(className);
        if (null == nvClassResult) {
            nvClassResult = new NvClassResult(className);
            nvTestSuiteResult.addResult(nvClassResult);
            NvProfileResult nvProfileResult = new NvProfileResult(profileName);
            nvClassResult.addResult(nvProfileResult);
            return nvProfileResult;
        }
        NvProfileResult nvProfileResult = (NvProfileResult)nvClassResult.getResult(profileName);
        if (null == nvProfileResult) {
            nvProfileResult = new NvProfileResult(profileName);
            nvClassResult.addResult(nvProfileResult);
            return nvProfileResult;
        }
        return nvProfileResult;
    }

    private Float getThreshold(String className, String testCaseName) {
        if (null == this.thresholdsMap) {
            return null;
        }
        Float threshold = this.thresholdsMap.get(className + "." + testCaseName);
        if (null == threshold) {
            threshold = this.thresholdsMap.get("default");
        }
        return threshold;
    }

    private boolean checkFailedException(String stackTrace) {
        return stackTrace.startsWith(ASSERTION_EXCEPTION_CLASS_NAME);
    }
}

