/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.nvemulation.plugin.results;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonSetter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jenkinsci.plugins.nvemulation.plugin.results.CountableResult;

public abstract class CountableResultParent<T extends CountableResult>
extends CountableResult
implements Serializable {
    private static final long serialVersionUID = -4125396948358407713L;
    @JsonIgnore
    private Map<String, T> results = new HashMap<String, T>();

    protected CountableResultParent() {
    }

    protected CountableResultParent(String name) {
        super(name);
    }

    public List<T> getResults() {
        Collection<T> values = this.results.values();
        if (values instanceof List) {
            return (List)values;
        }
        return new ArrayList<T>(values);
    }

    @JsonSetter
    public void setResults(List<T> results) {
        if (null != results) {
            for (CountableResult result : results) {
                this.results.put(result.getName(), result);
            }
        }
    }

    protected T getResult(String name) {
        return (T)((CountableResult)this.results.get(name));
    }

    protected void addResult(T result) {
        this.results.put(((CountableResult)result).getName(), result);
    }

    protected void addDuration(float duration) {
        this.setDuration(this.getDuration() + duration);
    }

    protected void addFailCount(int failCount) {
        this.setFailCount(this.getFailCount() + failCount);
    }

    protected void addErrorCount(int errorCount) {
        this.setErrorCount(this.getErrorCount() + errorCount);
    }

    protected void addSkipCount(int skipCount) {
        this.setSkipCount(this.getSkipCount() + skipCount);
    }

    protected void addPassCount(int passCount) {
        this.setPassCount(this.getPassCount() + passCount);
    }

    @Override
    public void tally() {
        for (CountableResult result : this.results.values()) {
            result.tally();
            this.addDuration(result.getDuration());
            this.addFailCount(result.getFailCount());
            this.addErrorCount(result.getErrorCount());
            this.addSkipCount(result.getSkipCount());
            this.addPassCount(result.getPassCount());
        }
    }
}

