/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.nvemulation.model;

import hudson.tasks.BuildStep;
import java.io.Serializable;
import java.util.List;
import org.jenkinsci.plugins.nvemulation.model.NvNetworkProfile;
import org.jenkinsci.plugins.nvemulation.model.NvServer;
import org.kohsuke.stapler.DataBoundConstructor;

public class NvModel
implements Serializable {
    private static final long serialVersionUID = 8642626061740581112L;
    private String serverName;
    private String includeClientIPs;
    private String excludeServerIPs;
    private String envVariable;
    private List<BuildStep> steps;
    private String reportFiles;
    private String thresholdsFile;
    private boolean useProxy;
    private NvServer nvServer;
    private List<NvNetworkProfile> profiles;

    @DataBoundConstructor
    public NvModel(String serverName, String includeClientIPs, String excludeServerIPs, String envVariable, String reportFiles, String thresholdsFile, List<BuildStep> steps) {
        this.serverName = serverName;
        this.includeClientIPs = includeClientIPs;
        this.excludeServerIPs = excludeServerIPs;
        this.envVariable = envVariable;
        this.steps = steps;
        this.reportFiles = reportFiles;
        this.thresholdsFile = thresholdsFile;
        this.useProxy = envVariable != null && !envVariable.isEmpty();
    }

    public String getServerName() {
        return this.serverName;
    }

    public String getIncludeClientIPs() {
        return this.includeClientIPs;
    }

    public String getExcludeServerIPs() {
        return this.excludeServerIPs;
    }

    public String getEnvVariable() {
        return this.envVariable;
    }

    public List<BuildStep> getSteps() {
        return this.steps;
    }

    public String getReportFiles() {
        return this.reportFiles;
    }

    public String getThresholdsFile() {
        return this.thresholdsFile;
    }

    public boolean isUseProxy() {
        return this.useProxy;
    }

    public NvServer getNvServer() {
        return this.nvServer;
    }

    public void setNvServer(NvServer nvServer) {
        this.nvServer = nvServer;
    }

    public List<NvNetworkProfile> getProfiles() {
        return this.profiles;
    }

    public void setProfiles(List<NvNetworkProfile> profiles) {
        this.profiles = profiles;
    }
}

