/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.harvest;

import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.TaskListener;
import hudson.plugins.harvest.HarvestChangeLogEntry;
import hudson.plugins.harvest.HarvestChangeLogParser;
import hudson.plugins.harvest.HarvestChangeLogSet;
import hudson.scm.ChangeLogParser;
import hudson.scm.PollingResult;
import hudson.scm.SCM;
import hudson.scm.SCMDescriptor;
import hudson.scm.SCMRevisionState;
import hudson.util.ArgumentListBuilder;
import hudson.util.FormValidation;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletException;
import net.sf.json.JSONObject;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.SystemUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

public class HarvestSCM
extends SCM {
    private final Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());
    private String broker = null;
    private String passwordFile = null;
    private String userId = null;
    private String password = null;
    private String projectName = null;
    private String state = null;
    private String viewPath = null;
    private String clientPath = null;
    private String processName = null;
    private String recursiveSearch = null;
    private boolean useSynchronize = true;
    private String extraOptions = null;

    @DataBoundConstructor
    public HarvestSCM(String broker, String passwordFile, String userId, String password, String projectName, String state, String viewPath, String clientPath, String processName, String recursiveSearch, Boolean useSynchronize, String extraOptions) {
        this.broker = broker;
        this.passwordFile = passwordFile;
        this.userId = userId;
        this.password = password;
        this.projectName = projectName;
        this.state = state;
        this.viewPath = viewPath;
        this.clientPath = clientPath;
        this.processName = processName;
        this.recursiveSearch = recursiveSearch;
        this.useSynchronize = useSynchronize;
        this.extraOptions = extraOptions;
    }

    public boolean supportsPolling() {
        return this.isUseSynchronize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkout(AbstractBuild<?, ?> build, Launcher launcher, FilePath workspace, BuildListener listener, File changeLogFile) throws IOException, InterruptedException {
        if (!this.useSynchronize) {
            this.logger.debug((Object)("deleting contents of workspace " + workspace));
            workspace.deleteContents();
        }
        this.logger.debug((Object)"starting checkout");
        List<HarvestChangeLogEntry> listOfChanges = this.checkoutInternal(launcher, workspace, (TaskListener)listener);
        if (!this.useSynchronize) {
            this.createEmptyChangeLog(changeLogFile, listener, "changelog");
        } else {
            HarvestChangeLogSet history = new HarvestChangeLogSet(build, listOfChanges);
            FileOutputStream fileOutputStream = new FileOutputStream(changeLogFile);
            HarvestChangeLogSet.saveToChangeLog(fileOutputStream, history);
            fileOutputStream.close();
        }
        String hcoLogFile = workspace.getRemote() + File.separator + "hco.log";
        try {
            BufferedReader r = new BufferedReader(new FileReader(hcoLogFile));
            try {
                String line = null;
                while ((line = r.readLine()) != null) {
                    listener.getLogger().println(line);
                }
            }
            finally {
                if (r != null) {
                    r.close();
                }
            }
        }
        catch (FileNotFoundException e) {
            listener.getLogger().println("File " + hcoLogFile + " does not exist, this most likely means there was a failure to call the hco command");
            throw e;
        }
        this.logger.debug((Object)"completing checkout");
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<HarvestChangeLogEntry> checkoutInternal(Launcher launcher, FilePath workspace, TaskListener listener) throws IOException, InterruptedException, FileNotFoundException {
        ArrayList<HarvestChangeLogEntry> listOfChanges = new ArrayList<HarvestChangeLogEntry>();
        ArgumentListBuilder cmd = this.prepareCommand(this.getDescriptor().getExecutable(), this.getDescriptor().getDefaultBroker(), this.getDescriptor().getDefaultPasswordFile(), this.getDescriptor().getDefaultUsername(), this.getDescriptor().getDefaultPassword(), workspace.getRemote());
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.logger.debug((Object)("launching command " + cmd.toList()));
        Path path = Paths.get(this.generateClientPath(workspace.getRemote()), new String[0]);
        if (!Files.exists(path, new LinkOption[0])) {
            listener.getLogger().println("Creating client workspace directory: " + this.generateClientPath(workspace.getRemote()));
            FileUtils.forceMkdir((File)new File(this.generateClientPath(workspace.getRemote())));
        }
        int rc = launcher.launch().cmds(cmd).stdout((OutputStream)baos).pwd(workspace).join();
        if (this.isUseSynchronize()) {
            FileInputStream fileInputStream = null;
            try {
                fileInputStream = new FileInputStream(new File(workspace.getRemote() + File.separator + "hco.log"));
                this.parse(fileInputStream, listOfChanges);
            }
            finally {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
        }
        return listOfChanges;
    }

    protected String generateClientPath(String workspacePath) {
        if (StringUtils.isNotEmpty((String)this.getClientPath()) && !".".equals(this.getClientPath())) {
            workspacePath = workspacePath + File.separator + this.getClientPath();
        }
        return workspacePath;
    }

    protected ArgumentListBuilder prepareCommand(String executable, String defaultBroker, String defaultPasswordFile, String defaultUsername, String defaultPassword, String workspacePath) throws IOException {
        workspacePath = this.generateClientPath(workspacePath);
        ArgumentListBuilder cmd = new ArgumentListBuilder();
        cmd.add(executable);
        cmd.add(new String[]{"-b", StringUtils.isEmpty((String)this.getBroker()) ? defaultBroker : this.getBroker()});
        if (StringUtils.isNotEmpty((String)defaultPasswordFile) && StringUtils.isEmpty((String)this.getUserId()) || StringUtils.isNotEmpty((String)this.getPasswordFile())) {
            cmd.add(new String[]{"-eh", StringUtils.isNotEmpty((String)this.getPasswordFile()) ? this.getPasswordFile() : defaultPasswordFile});
        } else {
            cmd.add(new String[]{"-usr", StringUtils.isEmpty((String)this.getUserId()) ? defaultUsername : this.getUserId()});
            cmd.add("-pw");
            cmd.add(StringUtils.isEmpty((String)this.getPassword()) ? defaultPassword : this.getPassword(), true);
        }
        cmd.add(new String[]{"-en", this.getProjectName()});
        cmd.add(new String[]{"-st", this.getState()});
        cmd.add(new String[]{"-vp", this.getViewPath()});
        cmd.add("-cp");
        if (SystemUtils.IS_OS_LINUX) {
            cmd.add(workspacePath);
        } else {
            cmd.addQuoted(workspacePath);
        }
        cmd.add(new String[]{"-pn", this.getProcessName()});
        cmd.add("-s");
        if (SystemUtils.IS_OS_LINUX) {
            cmd.add(this.getRecursiveSearch());
        } else {
            cmd.addQuoted(this.getRecursiveSearch());
        }
        if (this.isUseSynchronize()) {
            cmd.add("-sy");
            cmd.add("-nt");
        } else {
            cmd.add("-br");
        }
        cmd.add("-r");
        if (StringUtils.isNotEmpty((String)this.getExtraOptions())) {
            String[] aList;
            for (String a : aList = this.getExtraOptions().split(",")) {
                cmd.add(a);
            }
        }
        return cmd;
    }

    protected void parse(InputStream inputStream, List<HarvestChangeLogEntry> listOfChanges) throws IOException {
        BufferedReader br = new BufferedReader(new InputStreamReader(inputStream));
        Pattern pCheckout = Pattern.compile("I00020110: File (.*);([.\\d]+)  checked out to .*");
        Pattern pSummary = Pattern.compile("I00060080: Check out summary: Total: (\\d+) ; Success: (\\d+) ; Failed: (\\d+) ; Not Processed: (\\d+) \\.");
        String line = "";
        while ((line = br.readLine()) != null) {
            if (StringUtils.indexOf((String)line, (String)"E") == 0) {
                throw new IllegalArgumentException("error on line " + line);
            }
            if (StringUtils.indexOf((String)line, (String)"I00060040:") == 0 || StringUtils.indexOf((String)line, (String)"I00020052:") == 0) continue;
            if (StringUtils.indexOf((String)line, (String)"I00020110:") == 0) {
                HarvestChangeLogEntry e = new HarvestChangeLogEntry();
                Matcher m = pCheckout.matcher(line);
                if (!m.matches()) {
                    throw new IllegalArgumentException("could not parse checkout line " + line);
                }
                e.setFullName(m.group(1));
                e.setVersion(m.group(2));
                listOfChanges.add(e);
                continue;
            }
            if (StringUtils.indexOf((String)line, (String)"I00060080:") == 0) {
                Matcher m = pSummary.matcher(line);
                if (!m.matches()) {
                    throw new IllegalArgumentException("could not parse checkout line " + line);
                }
                if (!StringUtils.equals((String)"0", (String)m.group(3))) {
                    throw new IllegalArgumentException("failed files in line " + line);
                }
                if (StringUtils.equals((String)"0", (String)m.group(4))) continue;
                throw new IllegalArgumentException("not processed files in line " + line);
            }
            if (StringUtils.indexOf((String)line, (String)"Checkout has been executed successfully.") == 0) continue;
            throw new IllegalArgumentException("could not parse line " + line);
        }
    }

    public ChangeLogParser createChangeLogParser() {
        return new HarvestChangeLogParser();
    }

    public DescriptorImpl getDescriptor() {
        return DescriptorImpl.DESCRIPTOR;
    }

    public SCMRevisionState calcRevisionsFromBuild(AbstractBuild<?, ?> build, Launcher launcher, TaskListener listener) throws IOException, InterruptedException {
        return SCMRevisionState.NONE;
    }

    protected PollingResult compareRemoteRevisionWith(AbstractProject<?, ?> project, Launcher launcher, FilePath workspace, TaskListener listener, SCMRevisionState baseline) throws IOException, InterruptedException {
        List<HarvestChangeLogEntry> listOfChanges = this.checkoutInternal(launcher, workspace, listener);
        if (listOfChanges.size() > 0) {
            return PollingResult.SIGNIFICANT;
        }
        return PollingResult.NO_CHANGES;
    }

    public String getBroker() {
        return this.broker;
    }

    public void setBroker(String broker) {
        this.broker = broker;
    }

    public String getPasswordFile() {
        return this.passwordFile;
    }

    public void setPasswordFile(String passwordFile) {
        this.passwordFile = passwordFile;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public String getViewPath() {
        return this.viewPath;
    }

    public void setViewPath(String viewPath) {
        this.viewPath = viewPath;
    }

    public String getClientPath() {
        return this.clientPath;
    }

    public void setClientPath(String clientPath) {
        this.clientPath = clientPath;
    }

    public String getProcessName() {
        return this.processName;
    }

    public void setProcessName(String processName) {
        this.processName = processName;
    }

    public String getRecursiveSearch() {
        return this.recursiveSearch;
    }

    public void setRecursiveSearch(String recursiveSearch) {
        this.recursiveSearch = recursiveSearch;
    }

    public boolean isUseSynchronize() {
        return this.useSynchronize;
    }

    public void setUseSynchronize(boolean useSynchronize) {
        this.useSynchronize = useSynchronize;
    }

    public String getExtraOptions() {
        return this.extraOptions;
    }

    public void setExtraOptions(String extraOptions) {
        this.extraOptions = extraOptions;
    }

    public static final class DescriptorImpl
    extends SCMDescriptor<HarvestSCM> {
        @Extension
        public static final DescriptorImpl DESCRIPTOR = new DescriptorImpl();
        private static final Log LOGGER = LogFactory.getLog(DescriptorImpl.class);
        private String executable = "hco";
        private String defaultUsername;
        private String defaultPassword;
        private String defaultBroker;
        private String defaultPasswordFile;

        private DescriptorImpl() {
            super(HarvestSCM.class, null);
            this.load();
        }

        public boolean configure(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            LOGGER.debug((Object)("configuring from " + req));
            this.executable = Util.fixEmpty((String)req.getParameter("harvest.executable").trim());
            this.defaultUsername = Util.fixEmpty((String)req.getParameter("harvest.defaultUsername"));
            this.defaultPassword = Util.fixEmpty((String)req.getParameter("harvest.defaultPassword"));
            this.defaultBroker = Util.fixEmpty((String)req.getParameter("harvest.defaultBroker"));
            this.defaultPasswordFile = Util.fixEmpty((String)req.getParameter("harvest.defaultPasswordFile"));
            this.save();
            return true;
        }

        public FormValidation doExecutableCheck(@QueryParameter String value) throws IOException, ServletException {
            return FormValidation.validateExecutable((String)value);
        }

        public String getDisplayName() {
            return "CA Harvest";
        }

        public String getExecutable() {
            return this.executable;
        }

        public void setExecutable(String executable) {
            this.executable = executable;
        }

        public String getDefaultPasswordFile() {
            return this.defaultPasswordFile;
        }

        public String getDefaultUsername() {
            return this.defaultUsername;
        }

        public String getDefaultPassword() {
            return this.defaultPassword;
        }

        public String getDefaultBroker() {
            return this.defaultBroker;
        }

        public boolean hasDefaultUsername() {
            return !StringUtils.isEmpty((String)this.getDefaultUsername());
        }
    }
}

