/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.harvest;

import hudson.model.AbstractBuild;
import hudson.plugins.harvest.HarvestChangeLogEntry;
import hudson.scm.ChangeLogSet;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.digester.Digester;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ReflectionToStringBuilder;
import org.xml.sax.SAXException;

public class HarvestChangeLogSet
extends ChangeLogSet<HarvestChangeLogEntry> {
    private List<HarvestChangeLogEntry> history = null;

    public HarvestChangeLogSet(AbstractBuild<?, ?> build, List<HarvestChangeLogEntry> logs) {
        super(build);
        for (HarvestChangeLogEntry entry : logs) {
            entry.setParent(this);
        }
        this.history = Collections.unmodifiableList(logs);
    }

    public static ChangeLogSet<HarvestChangeLogEntry> parse(AbstractBuild<?, ?> build, File changeLogFile) throws IOException, SAXException {
        FileInputStream fileInputStream = new FileInputStream(changeLogFile);
        HarvestChangeLogSet logSet = HarvestChangeLogSet.parse(build, fileInputStream);
        ((InputStream)fileInputStream).close();
        return logSet;
    }

    protected static HarvestChangeLogSet parse(AbstractBuild<?, ?> build, InputStream inputStream) throws IOException, SAXException {
        ArrayList<HarvestChangeLogEntry> history = new ArrayList<HarvestChangeLogEntry>();
        Digester digester = new Digester();
        digester.setClassLoader(HarvestChangeLogSet.class.getClassLoader());
        digester.push(history);
        digester.addObjectCreate("*/entry", HarvestChangeLogEntry.class);
        digester.addBeanPropertySetter("*/entry/user");
        digester.addBeanPropertySetter("*/entry/msg");
        digester.addBeanPropertySetter("*/entry/fullName");
        digester.addBeanPropertySetter("*/entry/version");
        digester.addSetNext("*/entry", "add");
        digester.parse(inputStream);
        return new HarvestChangeLogSet(build, history);
    }

    public static void saveToChangeLog(OutputStream outputStream, ChangeLogSet<HarvestChangeLogEntry> history) throws IOException {
        PrintStream stream = new PrintStream(outputStream, false, "UTF-8");
        stream.println("<?xml version='1.0' encoding='UTF-8'?>");
        stream.println("<history>");
        for (HarvestChangeLogEntry entry : history) {
            stream.println("<entry>");
            stream.print("<user>");
            stream.print(entry.getAuthor());
            stream.println("</user>");
            stream.print("<msg>");
            stream.print(entry.getMsgEscaped());
            stream.println("</msg>");
            stream.print("<fullName>");
            stream.print(entry.getFullName());
            stream.println("</fullName>");
            stream.print("<version>");
            stream.print(entry.getVersion());
            stream.println("</version>");
            stream.println("</entry>");
        }
        stream.println("</history>");
        stream.close();
    }

    public boolean isEmptySet() {
        return this.history.size() == 0;
    }

    public Iterator<HarvestChangeLogEntry> iterator() {
        return this.history.iterator();
    }

    public List<HarvestChangeLogEntry> getLogs() {
        return this.history;
    }

    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals((Object)((Object)this), (Object)obj);
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)((Object)this));
    }

    public String toString() {
        return ReflectionToStringBuilder.toString((Object)((Object)this));
    }
}

