/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.googleplayandroidpublisher;

import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.services.androidpublisher.AndroidPublisher;
import com.google.common.base.Throwables;
import com.google.jenkins.plugins.credentials.oauth.GoogleOAuth2ScopeRequirement;
import com.google.jenkins.plugins.credentials.oauth.GoogleRobotCredentials;
import hudson.FilePath;
import hudson.model.AbstractBuild;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.remoting.VirtualChannel;
import java.io.File;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.List;
import jenkins.MasterToSlaveFileCallable;
import jenkins.model.Jenkins;
import net.dongliu.apk.parser.ApkParsers;
import net.dongliu.apk.parser.bean.ApkMeta;
import org.jenkinsci.plugins.googleplayandroidpublisher.AndroidPublisherScopeRequirement;
import org.jenkinsci.plugins.googleplayandroidpublisher.CredentialsException;
import org.jenkinsci.plugins.googleplayandroidpublisher.PublisherApiException;
import org.jenkinsci.plugins.googleplayandroidpublisher.UploadException;
import org.jenkinsci.plugins.tokenmacro.MacroEvaluationException;
import org.jenkinsci.plugins.tokenmacro.TokenMacro;

public class Util {
    static final String REGEX_LANGUAGE = "[a-z]{2,3}([-_][0-9A-Z]{2,})?";
    static final String REGEX_VARIABLE = "\\$([A-Za-z0-9_]+|\\{[A-Za-z0-9_]+\\}|\\$)";
    static final String[] SUPPORTED_LANGUAGES = new String[]{"af", "am", "ar", "be", "bg", "ca", "cs-CZ", "da-DK", "de-DE", "el-GR", "en-GB", "en-US", "es-419", "es-ES", "es-US", "et", "fa", "fi-FI", "fil", "fr-CA", "fr-FR", "hi-IN", "hr", "hu-HU", "id", "it-IT", "iw-IL", "ja-JP", "ko-KR", "lt", "lv", "ms", "nl-NL", "no-NO", "pl-PL", "pt-BR", "pt-PT", "rm", "ro", "ru-RU", "sk", "sl", "sr", "sv-SE", "sw", "th", "tr-TR", "uk", "vi", "zh-CN", "zh-TW", "zu"};

    public static String getPluginVersion() {
        String version = Jenkins.getInstance().getPluginManager().whichPlugin(Util.class).getVersion();
        int index = version.indexOf(32);
        return index == -1 ? version : version.substring(0, index);
    }

    public static String getApplicationId(FilePath apk) throws IOException, InterruptedException {
        return (String)apk.act((FilePath.FileCallable)new MasterToSlaveFileCallable<String>(){

            public String invoke(File f, VirtualChannel channel) throws IOException, InterruptedException {
                return Util.getApkMetadata(f).getPackageName();
            }
        });
    }

    static int getVersionCode(FilePath apk) throws IOException, InterruptedException {
        return (Integer)apk.act((FilePath.FileCallable)new MasterToSlaveFileCallable<Integer>(){

            public Integer invoke(File f, VirtualChannel channel) throws IOException, InterruptedException {
                return Util.getApkMetadata(f).getVersionCode().intValue();
            }
        });
    }

    static ApkMeta getApkMetadata(File apk) throws IOException {
        return ApkParsers.getMetaInfo((File)apk);
    }

    static String expand(Run<?, ?> run, TaskListener listener, String value) throws InterruptedException, IOException {
        if (!(run instanceof AbstractBuild)) {
            return value;
        }
        try {
            AbstractBuild build = (AbstractBuild)run;
            return hudson.Util.fixEmptyAndTrim((String)TokenMacro.expandAll((AbstractBuild)build, (TaskListener)listener, (String)value));
        }
        catch (MacroEvaluationException e) {
            listener.getLogger().println(e.getMessage());
            return value;
        }
    }

    static String getPublisherErrorMessage(UploadException e) {
        if (e instanceof CredentialsException) {
            return e.getMessage();
        }
        if (e instanceof PublisherApiException) {
            List<String> errors = ((PublisherApiException)e).getErrorMessages();
            if (errors.isEmpty()) {
                return "(unknown error)";
            }
            StringBuilder message = new StringBuilder("\n");
            for (String error : errors) {
                message.append("- ");
                message.append(error);
                message.append('\n');
            }
            return message.toString();
        }
        return Throwables.getStackTraceAsString((Throwable)e);
    }

    static AndroidPublisher getPublisherClient(GoogleRobotCredentials credentials, String pluginVersion) throws GeneralSecurityException {
        Credential credential = credentials.getGoogleCredential((GoogleOAuth2ScopeRequirement)new AndroidPublisherScopeRequirement());
        return new AndroidPublisher.Builder(credential.getTransport(), credential.getJsonFactory(), (HttpRequestInitializer)credential).setApplicationName(Util.getClientUserAgent(pluginVersion)).build();
    }

    private static String getClientUserAgent(String pluginVersion) {
        return String.format("Jenkins-GooglePlayAndroidPublisher/%s", pluginVersion);
    }
}

