/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.googleplayandroidpublisher;

import com.google.api.services.androidpublisher.model.Track;
import com.google.api.services.androidpublisher.model.TracksListResponse;
import com.google.jenkins.plugins.credentials.oauth.GoogleRobotCredentials;
import hudson.Util;
import hudson.model.TaskListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.jenkinsci.plugins.googleplayandroidpublisher.AbstractPublisherTask;
import org.jenkinsci.plugins.googleplayandroidpublisher.Constants;
import org.jenkinsci.plugins.googleplayandroidpublisher.ReleaseTrack;
import org.jenkinsci.plugins.googleplayandroidpublisher.UploadException;

abstract class TrackPublisherTask<V>
extends AbstractPublisherTask<V> {
    protected final String applicationId;
    protected final ReleaseTrack track;
    protected final double rolloutFraction;

    TrackPublisherTask(TaskListener listener, GoogleRobotCredentials credentials, String applicationId, ReleaseTrack track, double rolloutPercentage) {
        super(listener, credentials);
        this.applicationId = applicationId;
        this.track = track;
        this.rolloutFraction = rolloutPercentage / 100.0;
    }

    protected abstract int getNewestVersionCodeAllowed(Collection<Integer> var1);

    protected abstract boolean shouldReducingRolloutPercentageCauseFailure();

    protected void assignApksToTrack(Collection<Integer> versionCodes, ReleaseTrack track, double rolloutFraction) throws IOException, UploadException {
        int newestVersionCodeAllowed = this.getNewestVersionCodeAllowed(versionCodes);
        Track trackToAssign = new Track();
        trackToAssign.setTrack(track.getApiValue());
        trackToAssign.setVersionCodes(new ArrayList<Integer>(versionCodes));
        if (track == ReleaseTrack.PRODUCTION) {
            this.unassignOlderApks(ReleaseTrack.BETA, newestVersionCodeAllowed);
            Track rolloutTrack = this.fetchTrack(ReleaseTrack.ROLLOUT);
            if (rolloutTrack != null) {
                this.logger.println(String.format("Removing existing staged rollout APK(s): %s", Util.join((Collection)rolloutTrack.getVersionCodes(), (String)", ")));
                rolloutTrack.setVersionCodes(null);
                this.editService.tracks().update(this.applicationId, this.editId, rolloutTrack.getTrack(), rolloutTrack).execute();
            }
            if (rolloutFraction < 1.0) {
                double currentFraction;
                trackToAssign.setTrack(ReleaseTrack.ROLLOUT.getApiValue());
                trackToAssign.setUserFraction(Double.valueOf(rolloutFraction));
                double d = currentFraction = rolloutTrack == null ? rolloutFraction : rolloutTrack.getUserFraction();
                if (currentFraction > rolloutFraction) {
                    if (this.shouldReducingRolloutPercentageCauseFailure()) {
                        throw new UploadException(String.format("Staged rollout percentage cannot be reduced from %s%% to the configured %s%%", Constants.PERCENTAGE_FORMATTER.format(currentFraction * 100.0), Constants.PERCENTAGE_FORMATTER.format(rolloutFraction * 100.0)));
                    }
                    this.logger.println(String.format("Staged rollout percentage will remain at %s%% rather than the configured %s%% because there were APK(s) already in a staged rollout, and Google Play makes it impossible to reduce the rollout percentage in this case", Constants.PERCENTAGE_FORMATTER.format(currentFraction * 100.0), Constants.PERCENTAGE_FORMATTER.format(rolloutFraction * 100.0)));
                    trackToAssign.setUserFraction(Double.valueOf(currentFraction));
                }
            }
        } else if (rolloutFraction < 1.0) {
            this.logger.println("Ignoring staged rollout percentage as it only applies to production releases");
        }
        this.unassignOlderApks(ReleaseTrack.ALPHA, newestVersionCodeAllowed);
        if (trackToAssign.getTrack().equals(ReleaseTrack.ROLLOUT.getApiValue())) {
            this.logger.println(String.format("Assigning APK(s) to be rolled out to %s%% of production users...", Constants.PERCENTAGE_FORMATTER.format(trackToAssign.getUserFraction() * 100.0)));
        } else {
            this.logger.println(String.format("Assigning APK(s) to %s release track...", new Object[]{track}));
        }
        Track updatedTrack = (Track)this.editService.tracks().update(this.applicationId, this.editId, trackToAssign.getTrack(), trackToAssign).execute();
        this.logger.println(String.format("The %s release track will now contain APK(s) with version code(s): %s%n", new Object[]{track, Util.join((Collection)updatedTrack.getVersionCodes(), (String)", ")}));
    }

    private Track fetchTrack(ReleaseTrack track) throws IOException {
        List existingTracks = ((TracksListResponse)this.editService.tracks().list(this.applicationId, this.editId).execute()).getTracks();
        for (Track t : existingTracks) {
            if (!t.getTrack().equals(track.getApiValue())) continue;
            return t;
        }
        return null;
    }

    private void unassignOlderApks(ReleaseTrack track, int maxVersionCode) throws IOException {
        Track trackToAssign = this.fetchTrack(track);
        if (trackToAssign == null || trackToAssign.getVersionCodes() == null) {
            return;
        }
        ArrayList versionCodes = new ArrayList(trackToAssign.getVersionCodes());
        Iterator it = versionCodes.iterator();
        while (it.hasNext()) {
            if ((Integer)it.next() >= maxVersionCode) continue;
            it.remove();
        }
        trackToAssign.setVersionCodes(versionCodes);
        this.editService.tracks().update(this.applicationId, this.editId, trackToAssign.getTrack(), trackToAssign).execute();
    }
}

