/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.googleplayandroidpublisher;

import com.google.api.services.androidpublisher.model.Apk;
import com.google.api.services.androidpublisher.model.ApksListResponse;
import com.google.jenkins.plugins.credentials.oauth.GoogleRobotCredentials;
import hudson.Util;
import hudson.model.TaskListener;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.TreeSet;
import org.jenkinsci.plugins.googleplayandroidpublisher.ReleaseTrack;
import org.jenkinsci.plugins.googleplayandroidpublisher.TrackPublisherTask;
import org.jenkinsci.plugins.googleplayandroidpublisher.UploadException;

class TrackAssignmentTask
extends TrackPublisherTask<Boolean> {
    private final Collection<Integer> versionCodes;

    TrackAssignmentTask(TaskListener listener, GoogleRobotCredentials credentials, String applicationId, Collection<Integer> versionCodes, ReleaseTrack track, double rolloutPercentage) {
        super(listener, credentials, applicationId, track, rolloutPercentage);
        this.versionCodes = versionCodes;
    }

    @Override
    protected int getNewestVersionCodeAllowed(Collection<Integer> versionCodes) {
        TreeSet<Integer> sortedVersionCodes = new TreeSet<Integer>(versionCodes);
        return sortedVersionCodes.last() + 1;
    }

    @Override
    protected boolean shouldReducingRolloutPercentageCauseFailure() {
        return true;
    }

    @Override
    protected Boolean execute() throws IOException, InterruptedException, UploadException {
        this.logger.println(String.format("Authenticating to Google Play API...%n- Credential:     %s%n- Application ID: %s", this.getCredentialName(), this.applicationId));
        this.createEdit(this.applicationId);
        this.logger.println(String.format("Assigning %d APK(s) with application ID %s to %s release track", new Object[]{this.versionCodes.size(), this.applicationId, this.track}));
        ArrayList<Integer> missingVersionCodes = new ArrayList<Integer>(this.versionCodes);
        List existingApks = ((ApksListResponse)this.editService.apks().list(this.applicationId, this.editId).execute()).getApks();
        for (Apk apk : existingApks) {
            missingVersionCodes.remove(apk.getVersionCode());
        }
        if (!missingVersionCodes.isEmpty()) {
            this.logger.println(String.format("Could not assign APK(s) %s to %s, as these APKs do not exist: %s", new Object[]{Util.join(this.versionCodes, (String)", "), this.track, Util.join(missingVersionCodes, (String)", ")}));
            return false;
        }
        this.assignApksToTrack(this.versionCodes, this.track, this.rolloutFraction);
        try {
            this.logger.println("Applying changes to Google Play...");
            this.editService.commit(this.applicationId, this.editId).execute();
        }
        catch (SocketTimeoutException e) {
            this.logger.println(String.format("- An error occurred while applying changes: %s", e));
            return false;
        }
        this.logger.println("Changes were successfully applied to Google Play");
        return true;
    }
}

