/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.googleplayandroidpublisher;

import com.google.jenkins.plugins.credentials.oauth.GoogleRobotCredentials;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.AbortException;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.remoting.Callable;
import hudson.tasks.Builder;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.TreeSet;
import java.util.zip.ZipException;
import javax.annotation.Nonnull;
import net.dongliu.apk.parser.exception.ParserException;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.googleplayandroidpublisher.Constants;
import org.jenkinsci.plugins.googleplayandroidpublisher.FindFilesTask;
import org.jenkinsci.plugins.googleplayandroidpublisher.GooglePlayBuildStepDescriptor;
import org.jenkinsci.plugins.googleplayandroidpublisher.GooglePlayBuilder;
import org.jenkinsci.plugins.googleplayandroidpublisher.ReleaseTrack;
import org.jenkinsci.plugins.googleplayandroidpublisher.TrackAssignmentTask;
import org.jenkinsci.plugins.googleplayandroidpublisher.UploadException;
import org.jenkinsci.plugins.googleplayandroidpublisher.Util;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class ReleaseTrackAssignmentBuilder
extends GooglePlayBuilder {
    @DataBoundSetter
    private Boolean fromVersionCode;
    @DataBoundSetter
    private String applicationId;
    @DataBoundSetter
    private String versionCodes;
    @DataBoundSetter
    private String apkFilesPattern;
    @DataBoundSetter
    private String trackName;
    @DataBoundSetter
    private String rolloutPercentage;

    @DataBoundConstructor
    public ReleaseTrackAssignmentBuilder() {
    }

    public boolean isFromVersionCode() {
        return this.fromVersionCode == null || this.fromVersionCode != false;
    }

    public String getApplicationId() {
        return this.applicationId;
    }

    private String getExpandedApplicationId() throws IOException, InterruptedException {
        return this.expand(this.getApplicationId());
    }

    public String getVersionCodes() {
        return this.versionCodes;
    }

    private String getExpandedVersionCodes() throws IOException, InterruptedException {
        return this.expand(this.getVersionCodes());
    }

    public String getApkFilesPattern() {
        return hudson.Util.fixEmptyAndTrim((String)this.apkFilesPattern);
    }

    private String getExpandedApkFilesPattern() throws IOException, InterruptedException {
        return this.expand(this.getApkFilesPattern());
    }

    public String getTrackName() {
        return hudson.Util.fixEmptyAndTrim((String)this.trackName);
    }

    private String getCanonicalTrackName() throws IOException, InterruptedException {
        String name = this.expand(this.getTrackName());
        if (name == null) {
            return null;
        }
        return name.toLowerCase(Locale.ENGLISH);
    }

    public String getRolloutPercentage() {
        return hudson.Util.fixEmptyAndTrim((String)this.rolloutPercentage);
    }

    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"})
    private double getRolloutPercentageValue() throws IOException, InterruptedException {
        String pct = this.getRolloutPercentage();
        if (pct != null) {
            pct = pct.replace("%", "");
        }
        return hudson.Util.tryParseNumber((String)this.expand(pct), (Number)100.0).doubleValue();
    }

    private boolean isConfigValid(PrintStream logger) throws IOException, InterruptedException {
        double pct;
        ArrayList<String> errors = new ArrayList<String>();
        if (this.isFromVersionCode()) {
            if (this.getExpandedApplicationId() == null) {
                errors.add("No application ID was specified");
            }
            if (this.getExpandedVersionCodes() == null) {
                errors.add("No version codes were specified");
            }
        } else if (this.getExpandedApkFilesPattern() == null) {
            errors.add("Path or pattern to APK file(s) was not specified");
        }
        String trackName = this.getCanonicalTrackName();
        ReleaseTrack track = ReleaseTrack.fromConfigValue(trackName);
        if (trackName == null) {
            errors.add("Release track was not specified");
        } else if (track == null) {
            errors.add(String.format("'%s' is not a valid release track", trackName));
        } else if (track == ReleaseTrack.PRODUCTION && Arrays.binarySearch(Constants.ROLLOUT_PERCENTAGES, pct = this.getRolloutPercentageValue()) < 0) {
            errors.add(String.format("%s%% is not a valid rollout percentage", Constants.PERCENTAGE_FORMATTER.format(pct)));
        }
        if (!errors.isEmpty()) {
            logger.println("Cannot make changes to Google Play:");
            for (String error : errors) {
                logger.print("- ");
                logger.println(error);
            }
        }
        return errors.isEmpty();
    }

    @Override
    public void perform(@Nonnull Run<?, ?> run, @Nonnull FilePath workspace, @Nonnull Launcher launcher, @Nonnull TaskListener listener) throws InterruptedException, IOException {
        super.perform(run, workspace, launcher, listener);
        if (!this.assignApk(run, workspace, listener)) {
            throw new AbortException("APK assignment failed");
        }
    }

    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"})
    private boolean assignApk(@Nonnull Run<?, ?> run, @Nonnull FilePath workspace, @Nonnull TaskListener listener) throws IOException, InterruptedException {
        String applicationId;
        PrintStream logger = listener.getLogger();
        if (!this.isConfigValid(logger)) {
            return false;
        }
        TreeSet<Integer> versionCodeList = new TreeSet<Integer>();
        if (this.isFromVersionCode()) {
            applicationId = this.getExpandedApplicationId();
            String codes = this.getExpandedVersionCodes();
            for (String s : codes.split("[,\\s]+")) {
                int versionCode = hudson.Util.tryParseNumber((String)s.trim(), (Number)-1).intValue();
                if (versionCode == -1) continue;
                versionCodeList.add(versionCode);
            }
        } else {
            AppInfo info = this.getApplicationInfoForApks(workspace, logger, this.getExpandedApkFilesPattern());
            if (info == null) {
                return false;
            }
            applicationId = info.applicationId;
            versionCodeList.addAll(info.versionCodes);
        }
        try {
            GoogleRobotCredentials credentials = this.getCredentialsHandler().getServiceAccountCredentials();
            return (Boolean)workspace.act((Callable)new TrackAssignmentTask(listener, credentials, applicationId, versionCodeList, ReleaseTrack.fromConfigValue(this.getCanonicalTrackName()), this.getRolloutPercentageValue()));
        }
        catch (UploadException e) {
            logger.println(String.format("Upload failed: %s", Util.getPublisherErrorMessage(e)));
            logger.println("- No changes have been applied to the Google Play account");
            return false;
        }
    }

    private AppInfo getApplicationInfoForApks(FilePath workspace, PrintStream logger, String apkFilesPattern) throws IOException, InterruptedException {
        List relativePaths = (List)workspace.act((FilePath.FileCallable)new FindFilesTask(apkFilesPattern));
        if (relativePaths.isEmpty()) {
            logger.println(String.format("No APK files matching the pattern '%s' could be found", apkFilesPattern));
            return null;
        }
        HashSet<String> applicationIds = new HashSet<String>();
        ArrayList<Integer> versionCodes = new ArrayList<Integer>();
        for (String path : relativePaths) {
            int versionCode;
            FilePath apk = workspace.child(path);
            try {
                applicationIds.add(Util.getApplicationId(apk));
                versionCode = Util.getVersionCode(apk);
                versionCodes.add(versionCode);
            }
            catch (ZipException e) {
                throw new IOException(String.format("File does not appear to be a valid APK: %s", apk.getRemote()), e);
            }
            catch (ParserException e) {
                logger.println(String.format("File does not appear to be a valid APK: %s%n- %s", apk.getRemote(), e.getMessage()));
                throw e;
            }
            logger.println(String.format("Found APK file with version code %d: %s", versionCode, path));
        }
        if (applicationIds.size() != 1) {
            logger.println("Multiple APKs were found but they have inconsistent application IDs:");
            for (String id : applicationIds) {
                logger.print("- ");
                logger.println(id);
            }
            return null;
        }
        return new AppInfo((String)applicationIds.iterator().next(), versionCodes);
    }

    @Symbol(value={"androidApkMove"})
    @Extension
    public static final class DescriptorImpl
    extends GooglePlayBuildStepDescriptor<Builder> {
        public String getDisplayName() {
            return "Move Android APKs to a different release track";
        }
    }

    private static final class AppInfo {
        final String applicationId;
        final List<Integer> versionCodes;

        AppInfo(String applicationId, List<Integer> versionCodes) {
            this.applicationId = applicationId;
            this.versionCodes = versionCodes;
        }
    }
}

