/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.googleplayandroidpublisher;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public enum ReleaseTrack {
    ALPHA,
    BETA,
    PRODUCTION,
    ROLLOUT(false);

    private final boolean visibleForConfig;

    private ReleaseTrack() {
        this(true);
    }

    private ReleaseTrack(boolean visible) {
        this.visibleForConfig = visible;
    }

    public static List<String> getConfigValues() {
        ArrayList<String> tracks = new ArrayList<String>();
        for (ReleaseTrack rt : ReleaseTrack.values()) {
            if (!rt.visibleForConfig) continue;
            tracks.add(rt.getApiValue());
        }
        return tracks;
    }

    public static ReleaseTrack fromConfigValue(String name) {
        for (ReleaseTrack rt : ReleaseTrack.values()) {
            if (!rt.visibleForConfig || !rt.name().equalsIgnoreCase(name)) continue;
            return rt;
        }
        return null;
    }

    public String getApiValue() {
        return this.name().toLowerCase(Locale.ENGLISH);
    }

    public String toString() {
        return this.getApiValue();
    }
}

