/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.googleplayandroidpublisher;

import com.google.api.client.googleapis.json.GoogleJsonError;
import com.google.api.client.googleapis.json.GoogleJsonResponseException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jenkinsci.plugins.googleplayandroidpublisher.UploadException;

public class PublisherApiException
extends UploadException {
    private List<String> errorMessages;

    public PublisherApiException(IOException cause) {
        super(cause);
        ArrayList<String> errors = new ArrayList<String>();
        if (cause instanceof GoogleJsonResponseException) {
            GoogleJsonError details = ((GoogleJsonResponseException)((Object)cause)).getDetails();
            if (details == null) {
                if (((GoogleJsonResponseException)((Object)cause)).getStatusCode() == 401) {
                    errors.add("The API credentials provided do not have permission to apply these changes");
                }
            } else {
                for (GoogleJsonError.ErrorInfo error : details.getErrors()) {
                    errors.add(error.getMessage());
                }
                this.errorMessages = Collections.unmodifiableList(errors);
            }
        }
    }

    @Nonnull
    public List<String> getErrorMessages() {
        return this.errorMessages;
    }

    @Nullable
    public String getErrorMessage() {
        return this.errorMessages.isEmpty() ? null : this.errorMessages.get(0);
    }
}

