/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.googleplayandroidpublisher;

import com.google.jenkins.plugins.credentials.domains.RequiresDomain;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Builder;
import java.io.IOException;
import javax.annotation.Nonnull;
import jenkins.tasks.SimpleBuildStep;
import org.jenkinsci.plugins.googleplayandroidpublisher.AndroidPublisherScopeRequirement;
import org.jenkinsci.plugins.googleplayandroidpublisher.CredentialsException;
import org.jenkinsci.plugins.googleplayandroidpublisher.CredentialsHandler;
import org.jenkinsci.plugins.googleplayandroidpublisher.Util;
import org.kohsuke.stapler.DataBoundSetter;

@RequiresDomain(value=AndroidPublisherScopeRequirement.class)
public abstract class GooglePlayBuilder
extends Builder
implements SimpleBuildStep {
    protected static final transient ThreadLocal<Run<?, ?>> currentBuild = new ThreadLocal();
    protected static final transient ThreadLocal<TaskListener> currentListener = new ThreadLocal();
    private transient CredentialsHandler credentialsHandler;
    private String googleCredentialsId;

    @DataBoundSetter
    public void setGoogleCredentialsId(String googleCredentialsId) {
        this.googleCredentialsId = googleCredentialsId;
    }

    public final String getGoogleCredentialsId() {
        return this.googleCredentialsId;
    }

    public void perform(@Nonnull Run<?, ?> run, @Nonnull FilePath workspace, @Nonnull Launcher launcher, @Nonnull TaskListener listener) throws InterruptedException, IOException {
        currentBuild.set(run);
        currentListener.set(listener);
    }

    protected CredentialsHandler getCredentialsHandler() throws CredentialsException {
        if (this.credentialsHandler == null) {
            this.credentialsHandler = new CredentialsHandler(this.googleCredentialsId);
        }
        return this.credentialsHandler;
    }

    protected String expand(String value) throws IOException, InterruptedException {
        return Util.expand(currentBuild.get(), currentListener.get(), value);
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }
}

