/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.googleplayandroidpublisher;

import com.google.jenkins.plugins.credentials.oauth.GoogleRobotCredentials;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Util;
import hudson.model.AbstractProject;
import hudson.model.Describable;
import hudson.model.Descriptor;
import hudson.tasks.BuildStep;
import hudson.tasks.BuildStepDescriptor;
import hudson.util.ComboBoxModel;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import net.sf.json.JSONObject;
import org.jenkinsci.plugins.googleplayandroidpublisher.Constants;
import org.jenkinsci.plugins.googleplayandroidpublisher.CredentialsHandler;
import org.jenkinsci.plugins.googleplayandroidpublisher.EphemeralCredentialsException;
import org.jenkinsci.plugins.googleplayandroidpublisher.GooglePlayPublisher;
import org.jenkinsci.plugins.googleplayandroidpublisher.ReleaseTrack;
import org.jenkinsci.plugins.googleplayandroidpublisher.UploadException;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

public abstract class GooglePlayBuildStepDescriptor<T extends BuildStep & Describable<T>>
extends BuildStepDescriptor<T> {
    public GooglePlayBuildStepDescriptor() {
        this.load();
    }

    public ListBoxModel doFillGoogleCredentialsIdItems() {
        GoogleRobotCredentials.CredentialsListBoxModel credentials = GoogleRobotCredentials.getCredentialsListBox(GooglePlayPublisher.class);
        if (credentials.isEmpty()) {
            credentials.add("(No Google Play account credentials have been added to Jenkins)", null);
        }
        return credentials;
    }

    public FormValidation doCheckGoogleCredentialsId(@QueryParameter String value) {
        GoogleRobotCredentials.CredentialsListBoxModel credentials = GoogleRobotCredentials.getCredentialsListBox(GooglePlayPublisher.class);
        if (credentials.isEmpty()) {
            return FormValidation.error((String)"You must add at least one Google Service Account via the Credentials page");
        }
        if (value == null || value.isEmpty() || value.matches("\\$\\{[A-Za-z0-9_]+}")) {
            return FormValidation.ok();
        }
        try {
            new CredentialsHandler(value).getServiceAccountCredentials();
        }
        catch (EphemeralCredentialsException e) {
            return FormValidation.warning((String)e.getMessage());
        }
        catch (UploadException e) {
            return FormValidation.error((String)e.getMessage());
        }
        return FormValidation.ok();
    }

    public FormValidation doCheckApkFilesPattern(@QueryParameter String value) {
        if (Util.fixEmptyAndTrim((String)value) == null) {
            return FormValidation.error((String)"An APK file path or pattern is required");
        }
        return FormValidation.ok();
    }

    public FormValidation doCheckTrackName(@QueryParameter String value) {
        if (Util.fixEmptyAndTrim((String)value) == null) {
            return FormValidation.error((String)"A release track is required");
        }
        return FormValidation.ok();
    }

    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"})
    public FormValidation doCheckRolloutPercentage(@QueryParameter String value) {
        if ((value = Util.fixEmptyAndTrim((String)value)) == null || value.matches("\\$([A-Za-z0-9_]+|\\{[A-Za-z0-9_]+\\}|\\$)")) {
            return FormValidation.ok();
        }
        double lowest = Constants.ROLLOUT_PERCENTAGES[0];
        double highest = 100.0;
        double pct = Util.tryParseNumber((String)value.replace("%", ""), (Number)100.0).doubleValue();
        if (Double.compare(pct, lowest) < 0 || Double.compare(pct, 100.0) > 0) {
            return FormValidation.error((String)"Percentage value must be between %s and %s%%", (Object[])new Object[]{Constants.PERCENTAGE_FORMATTER.format(lowest), Constants.PERCENTAGE_FORMATTER.format(100.0)});
        }
        return FormValidation.ok();
    }

    public ComboBoxModel doFillTrackNameItems() {
        return new ComboBoxModel(ReleaseTrack.getConfigValues());
    }

    public ComboBoxModel doFillRolloutPercentageItems() {
        ComboBoxModel list = new ComboBoxModel();
        for (double pct : Constants.ROLLOUT_PERCENTAGES) {
            list.add((Object)String.format("%s%%", Constants.PERCENTAGE_FORMATTER.format(pct)));
        }
        return list;
    }

    public boolean isApplicable(Class<? extends AbstractProject> c) {
        return true;
    }

    public boolean configure(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
        this.save();
        return super.configure(req, formData);
    }
}

