/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.googleplayandroidpublisher;

import com.google.api.client.googleapis.json.GoogleJsonResponseException;
import com.google.api.client.http.AbstractInputStreamContent;
import com.google.api.client.http.FileContent;
import com.google.api.services.androidpublisher.AndroidPublisher;
import com.google.api.services.androidpublisher.model.Apk;
import com.google.api.services.androidpublisher.model.ApkListing;
import com.google.api.services.androidpublisher.model.ApksListResponse;
import com.google.api.services.androidpublisher.model.ExpansionFile;
import com.google.api.services.androidpublisher.model.ExpansionFilesUploadResponse;
import com.google.jenkins.plugins.credentials.oauth.GoogleRobotCredentials;
import hudson.FilePath;
import hudson.model.TaskListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeSet;
import net.dongliu.apk.parser.bean.ApkMeta;
import org.apache.commons.codec.digest.DigestUtils;
import org.jenkinsci.plugins.googleplayandroidpublisher.ApkPublisher;
import org.jenkinsci.plugins.googleplayandroidpublisher.ReleaseTrack;
import org.jenkinsci.plugins.googleplayandroidpublisher.TrackPublisherTask;
import org.jenkinsci.plugins.googleplayandroidpublisher.UploadException;
import org.jenkinsci.plugins.googleplayandroidpublisher.Util;

class ApkUploadTask
extends TrackPublisherTask<Boolean> {
    private final FilePath workspace;
    private final List<FilePath> apkFiles;
    private final Map<FilePath, FilePath> apkFilesToMappingFiles;
    private final Map<Integer, ApkPublisher.ExpansionFileSet> expansionFiles;
    private final boolean usePreviousExpansionFilesIfMissing;
    private final ApkPublisher.RecentChanges[] recentChangeList;
    private final List<Integer> existingVersionCodes;
    private int latestMainExpansionFileVersionCode;
    private int latestPatchExpansionFileVersionCode;

    ApkUploadTask(TaskListener listener, GoogleRobotCredentials credentials, String applicationId, FilePath workspace, List<FilePath> apkFiles, Map<FilePath, FilePath> apkFilesToMappingFiles, Map<Integer, ApkPublisher.ExpansionFileSet> expansionFiles, boolean usePreviousExpansionFilesIfMissing, ReleaseTrack track, double rolloutPercentage, ApkPublisher.RecentChanges[] recentChangeList) {
        super(listener, credentials, applicationId, track, rolloutPercentage);
        this.workspace = workspace;
        this.apkFiles = apkFiles;
        this.apkFilesToMappingFiles = apkFilesToMappingFiles;
        this.expansionFiles = expansionFiles;
        this.usePreviousExpansionFilesIfMissing = usePreviousExpansionFilesIfMissing;
        this.recentChangeList = recentChangeList;
        this.existingVersionCodes = new ArrayList<Integer>();
    }

    @Override
    protected int getNewestVersionCodeAllowed(Collection<Integer> versionCodes) {
        TreeSet<Integer> sortedVersionCodes = new TreeSet<Integer>(versionCodes);
        return sortedVersionCodes.first();
    }

    @Override
    protected boolean shouldReducingRolloutPercentageCauseFailure() {
        return false;
    }

    @Override
    protected Boolean execute() throws IOException, InterruptedException, UploadException {
        block11: {
            this.logger.println(String.format("Authenticating to Google Play API...%n- Credential:     %s%n- Application ID: %s%n", this.getCredentialName(), this.applicationId));
            this.createEdit(this.applicationId);
            List existingApks = ((ApksListResponse)this.editService.apks().list(this.applicationId, this.editId).execute()).getApks();
            for (Object apk : existingApks) {
                this.existingVersionCodes.add(apk.getVersionCode());
            }
            this.logger.println(String.format("Uploading %d APK(s) with application ID: %s%n", this.apkFiles.size(), this.applicationId));
            ArrayList<Integer> uploadedVersionCodes = new ArrayList<Integer>();
            for (FilePath apkFile : this.apkFiles) {
                ApkMeta metadata = Util.getApkMetadata(new File(apkFile.getRemote()));
                String apkSha1Hash = ApkUploadTask.getSha1Hash(apkFile.getRemote());
                this.logger.println(String.format("      APK file: %s", this.getRelativeFileName(apkFile)));
                this.logger.println(String.format("    SHA-1 hash: %s", apkSha1Hash));
                this.logger.println(String.format("   versionCode: %d", metadata.getVersionCode()));
                this.logger.println(String.format(" minSdkVersion: %s", metadata.getMinSdkVersion()));
                for (Apk apk : existingApks) {
                    if (!apk.getBinary().getSha1().toLowerCase(Locale.ENGLISH).equals(apkSha1Hash)) continue;
                    this.logger.println();
                    this.logger.println("This APK already exists in the Google Play account; it cannot be uploaded again");
                    return false;
                }
                FileContent apk = new FileContent("application/vnd.android.package-archive", new File(apkFile.getRemote()));
                Apk uploadedApk = (Apk)this.editService.apks().upload(this.applicationId, this.editId, (AbstractInputStreamContent)apk).execute();
                uploadedVersionCodes.add(uploadedApk.getVersionCode());
                FilePath mappingFile = this.apkFilesToMappingFiles.get(apkFile);
                if (mappingFile != null) {
                    this.logger.println(String.format(" Uploading associated ProGuard mapping file: %s", this.getRelativeFileName(mappingFile)));
                    FileContent mapping = new FileContent("application/octet-stream", new File(mappingFile.getRemote()));
                    this.editService.deobfuscationfiles().upload(this.applicationId, this.editId, uploadedApk.getVersionCode(), "proguard", (AbstractInputStreamContent)mapping).execute();
                }
                this.logger.println("");
            }
            if (!this.expansionFiles.isEmpty() || this.usePreviousExpansionFilesIfMissing) {
                Object apk;
                apk = uploadedVersionCodes.iterator();
                while (apk.hasNext()) {
                    int versionCode = (Integer)apk.next();
                    ApkPublisher.ExpansionFileSet fileSet = this.expansionFiles.get(versionCode);
                    FilePath mainFile = fileSet == null ? null : fileSet.getMainFile();
                    FilePath patchFile = fileSet == null ? null : fileSet.getPatchFile();
                    this.logger.println(String.format("Handling expansion files for versionCode %d", versionCode));
                    this.applyExpansionFile(versionCode, "main", mainFile, this.usePreviousExpansionFilesIfMissing);
                    this.applyExpansionFile(versionCode, "patch", patchFile, this.usePreviousExpansionFilesIfMissing);
                    this.logger.println();
                }
            }
            this.assignApksToTrack(uploadedVersionCodes, this.track, this.rolloutFraction);
            if (this.recentChangeList != null) {
                for (Integer versionCode : uploadedVersionCodes) {
                    AndroidPublisher.Edits.Apklistings listings = this.editService.apklistings();
                    for (ApkPublisher.RecentChanges changes : this.recentChangeList) {
                        ApkListing listing = new ApkListing().setLanguage(changes.language).setRecentChanges(changes.text);
                        listings.update(this.applicationId, this.editId, versionCode, changes.language, listing).execute();
                    }
                }
            }
            try {
                this.logger.println("Applying changes to Google Play...");
                this.editService.commit(this.applicationId, this.editId).execute();
            }
            catch (SocketTimeoutException e) {
                this.logger.println(String.format("- An error occurred while applying changes: %s", e));
                this.logger.println("- Checking whether the changes have been applied anyway...\n");
                if (this.wereApksUploaded(uploadedVersionCodes)) break block11;
                this.logger.println("The APKs that were uploaded were not found on Google Play");
                this.logger.println("- No changes have been applied to the Google Play account");
                return false;
            }
        }
        this.logger.println("Changes were successfully applied to Google Play");
        return true;
    }

    private void applyExpansionFile(int versionCode, String type, FilePath filePath, boolean usePreviousIfMissing) throws IOException {
        if (filePath != null) {
            this.logger.println(String.format("- Uploading new %s expansion file: %s", type, filePath.getName()));
            this.uploadExpansionFile(versionCode, type, filePath);
            return;
        }
        if (usePreviousIfMissing) {
            int latestVersionCodeWithExpansion;
            this.fetchLatestExpansionFileVersionCodes();
            int n = latestVersionCodeWithExpansion = type.equals("main") ? this.latestMainExpansionFileVersionCode : this.latestPatchExpansionFileVersionCode;
            if (latestVersionCodeWithExpansion == -1) {
                this.logger.println(String.format("- No %1$s expansion file to apply, and no existing APK with a %1$s expansion file was found", type));
                return;
            }
            this.logger.println(String.format("- Applying %s expansion file from previous APK: %d", type, latestVersionCodeWithExpansion));
            ExpansionFile fileRef = new ExpansionFile().setReferencesVersion(Integer.valueOf(latestVersionCodeWithExpansion));
            this.editService.expansionfiles().update(this.applicationId, this.editId, Integer.valueOf(versionCode), type, fileRef).execute();
            return;
        }
        this.logger.println(String.format("- No %s expansion file to apply", type));
    }

    private void fetchLatestExpansionFileVersionCodes() throws IOException {
        if (this.latestMainExpansionFileVersionCode != 0 && this.latestPatchExpansionFileVersionCode != 0) {
            return;
        }
        Collections.sort(this.existingVersionCodes);
        Collections.reverse(this.existingVersionCodes);
        this.latestMainExpansionFileVersionCode = this.fetchLatestExpansionFileVersionCode("main");
        this.latestPatchExpansionFileVersionCode = this.fetchLatestExpansionFileVersionCode("patch");
    }

    private int fetchLatestExpansionFileVersionCode(String type) throws IOException {
        for (int versionCode : this.existingVersionCodes) {
            ExpansionFile file = this.getExpansionFile(versionCode, type);
            if (file == null) continue;
            if (file.getFileSize() != null && file.getFileSize() > 0L) {
                return versionCode;
            }
            if (file.getReferencesVersion() == null || file.getReferencesVersion() <= 0) continue;
            return file.getReferencesVersion();
        }
        return -1;
    }

    private ExpansionFile getExpansionFile(int versionCode, String type) throws IOException {
        try {
            return (ExpansionFile)this.editService.expansionfiles().get(this.applicationId, this.editId, Integer.valueOf(versionCode), type).execute();
        }
        catch (GoogleJsonResponseException e) {
            if (e.getStatusCode() == 404) {
                return null;
            }
            throw e;
        }
    }

    private ExpansionFilesUploadResponse uploadExpansionFile(int versionCode, String type, FilePath filePath) throws IOException {
        FileContent file = new FileContent("application/octet-stream", new File(filePath.getRemote()));
        return (ExpansionFilesUploadResponse)this.editService.expansionfiles().upload(this.applicationId, this.editId, Integer.valueOf(versionCode), type, (AbstractInputStreamContent)file).execute();
    }

    private boolean wereApksUploaded(Collection<Integer> uploadedVersionCodes) throws IOException {
        this.createEdit(this.applicationId);
        ArrayList<Integer> currentVersionCodes = new ArrayList<Integer>();
        List currentApks = ((ApksListResponse)this.editService.apks().list(this.applicationId, this.editId).execute()).getApks();
        for (Apk apk : currentApks) {
            currentVersionCodes.add(apk.getVersionCode());
        }
        return uploadedVersionCodes.removeAll(currentVersionCodes);
    }

    private String getRelativeFileName(FilePath file) {
        String ws = this.workspace.getRemote();
        String path = file.getRemote();
        if (path.startsWith(ws) && path.length() > ws.length()) {
            path = path.substring(ws.length());
        }
        if (path.charAt(0) == File.separatorChar && path.length() > 1) {
            path = path.substring(1);
        }
        return path;
    }

    private static String getSha1Hash(String path) throws IOException {
        try (FileInputStream fis = new FileInputStream(path);){
            String string = DigestUtils.sha1Hex((InputStream)fis).toLowerCase(Locale.ENGLISH);
            return string;
        }
    }
}

