/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.googleplayandroidpublisher;

import com.google.jenkins.plugins.credentials.oauth.GoogleRobotCredentials;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.AbortException;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.remoting.Callable;
import hudson.tasks.Publisher;
import hudson.util.ComboBoxModel;
import hudson.util.FormValidation;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.zip.ZipException;
import javax.annotation.Nonnull;
import net.dongliu.apk.parser.exception.ParserException;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.googleplayandroidpublisher.ApkUploadTask;
import org.jenkinsci.plugins.googleplayandroidpublisher.Constants;
import org.jenkinsci.plugins.googleplayandroidpublisher.FindFilesTask;
import org.jenkinsci.plugins.googleplayandroidpublisher.GooglePlayBuildStepDescriptor;
import org.jenkinsci.plugins.googleplayandroidpublisher.GooglePlayPublisher;
import org.jenkinsci.plugins.googleplayandroidpublisher.ReleaseTrack;
import org.jenkinsci.plugins.googleplayandroidpublisher.UploadException;
import org.jenkinsci.plugins.googleplayandroidpublisher.Util;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.export.Exported;

public class ApkPublisher
extends GooglePlayPublisher {
    @DataBoundSetter
    private String apkFilesPattern;
    @DataBoundSetter
    private String deobfuscationFilesPattern;
    @DataBoundSetter
    private String expansionFilesPattern;
    @DataBoundSetter
    private boolean usePreviousExpansionFilesIfMissing;
    @DataBoundSetter
    private String trackName;
    @DataBoundSetter
    private String rolloutPercentage;
    @DataBoundSetter
    private RecentChanges[] recentChangeList;

    @DataBoundConstructor
    public ApkPublisher() {
    }

    public String getApkFilesPattern() {
        return hudson.Util.fixEmptyAndTrim((String)this.apkFilesPattern);
    }

    private String getExpandedApkFilesPattern() throws IOException, InterruptedException {
        return this.expand(this.getApkFilesPattern());
    }

    public String getDeobfuscationFilesPattern() {
        return hudson.Util.fixEmptyAndTrim((String)this.deobfuscationFilesPattern);
    }

    private String getExpandedDeobfuscationFilesPattern() throws IOException, InterruptedException {
        return this.expand(this.getDeobfuscationFilesPattern());
    }

    public String getExpansionFilesPattern() {
        return hudson.Util.fixEmptyAndTrim((String)this.expansionFilesPattern);
    }

    private String getExpandedExpansionFilesPattern() throws IOException, InterruptedException {
        return this.expand(this.getExpansionFilesPattern());
    }

    public boolean getUsePreviousExpansionFilesIfMissing() {
        return this.usePreviousExpansionFilesIfMissing;
    }

    public String getTrackName() {
        return hudson.Util.fixEmptyAndTrim((String)this.trackName);
    }

    private String getCanonicalTrackName() throws IOException, InterruptedException {
        String name = this.expand(this.getTrackName());
        if (name == null) {
            return null;
        }
        return name.toLowerCase(Locale.ENGLISH);
    }

    public String getRolloutPercentage() {
        return hudson.Util.fixEmptyAndTrim((String)this.rolloutPercentage);
    }

    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"})
    private double getRolloutPercentageValue() throws IOException, InterruptedException {
        String pct = this.getRolloutPercentage();
        if (pct != null) {
            pct = pct.replace("%", "");
        }
        return hudson.Util.tryParseNumber((String)this.expand(pct), (Number)100.0).doubleValue();
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"})
    public RecentChanges[] getRecentChangeList() {
        return this.recentChangeList;
    }

    private RecentChanges[] getExpandedRecentChangesList() throws IOException, InterruptedException {
        if (this.recentChangeList == null) {
            return null;
        }
        RecentChanges[] expanded = new RecentChanges[this.recentChangeList.length];
        for (int i = 0; i < this.recentChangeList.length; ++i) {
            RecentChanges r = this.recentChangeList[i];
            expanded[i] = new RecentChanges(this.expand(r.language), this.expand(r.text));
        }
        return expanded;
    }

    private boolean isConfigValid(PrintStream logger) throws IOException, InterruptedException {
        double pct;
        ArrayList<String> errors = new ArrayList<String>();
        if (this.getExpandedApkFilesPattern() == null) {
            errors.add("Path or pattern to APK file was not specified");
        }
        String trackName = this.getCanonicalTrackName();
        ReleaseTrack track = ReleaseTrack.fromConfigValue(trackName);
        if (trackName == null) {
            errors.add("Release track was not specified");
        } else if (track == null) {
            errors.add(String.format("'%s' is not a valid release track", trackName));
        } else if (track == ReleaseTrack.PRODUCTION && Arrays.binarySearch(Constants.ROLLOUT_PERCENTAGES, pct = this.getRolloutPercentageValue()) < 0) {
            errors.add(String.format("%s%% is not a valid rollout percentage", Constants.PERCENTAGE_FORMATTER.format(pct)));
        }
        if (!errors.isEmpty()) {
            logger.println("Cannot upload to Google Play:");
            for (String error : errors) {
                logger.print("- ");
                logger.println(error);
            }
        }
        return errors.isEmpty();
    }

    @Override
    public void perform(@Nonnull Run<?, ?> run, @Nonnull FilePath workspace, @Nonnull Launcher launcher, @Nonnull TaskListener listener) throws InterruptedException, IOException {
        super.perform(run, workspace, launcher, listener);
        if (!this.publishApk(run, workspace, listener)) {
            throw new AbortException("APK upload failed");
        }
    }

    private boolean publishApk(@Nonnull Run<?, ?> run, @Nonnull FilePath workspace, @Nonnull TaskListener listener) throws InterruptedException, IOException {
        PrintStream logger = listener.getLogger();
        Result buildResult = run.getResult();
        if (buildResult != null && buildResult.isWorseThan(Result.UNSTABLE)) {
            logger.println("Skipping upload to Google Play due to build result");
            return true;
        }
        if (!this.isConfigValid(logger)) {
            return false;
        }
        String filesPattern = this.getExpandedApkFilesPattern();
        List relativePaths = (List)workspace.act((FilePath.FileCallable)new FindFilesTask(filesPattern));
        if (relativePaths.isEmpty()) {
            logger.println(String.format("No APK files matching the pattern '%s' could be found", filesPattern));
            return false;
        }
        ArrayList<FilePath> apkFiles = new ArrayList<FilePath>();
        HashSet<String> applicationIds = new HashSet<String>();
        TreeSet<Integer> versionCodes = new TreeSet<Integer>();
        for (String path : relativePaths) {
            FilePath apk = workspace.child(path);
            try {
                applicationIds.add(Util.getApplicationId(apk));
                versionCodes.add(Util.getVersionCode(apk));
            }
            catch (ZipException e) {
                logger.println(String.format("File does not appear to be a valid APK: %s", apk.getRemote()));
                return false;
            }
            catch (ParserException e) {
                logger.println(String.format("File does not appear to be a valid APK: %s%n- %s", apk.getRemote(), e.getMessage()));
                return false;
            }
            catch (IOException e) {
                logger.println(String.format("File does not appear to be a valid APK: %s", apk.getRemote()));
                throw e;
            }
            apkFiles.add(apk);
        }
        if (applicationIds.size() != 1) {
            logger.println(String.format("Multiple APKs matched the pattern '%s', but they have inconsistent application IDs:", filesPattern));
            for (String id : applicationIds) {
                logger.print("- ");
                logger.println(id);
            }
            return false;
        }
        HashMap<FilePath, FilePath> apkFilesToMappingFiles = new HashMap<FilePath, FilePath>();
        String mappingFilesPattern = this.getExpandedDeobfuscationFilesPattern();
        if (this.getExpandedDeobfuscationFilesPattern() != null) {
            List relativeMappingPaths = (List)workspace.act((FilePath.FileCallable)new FindFilesTask(mappingFilesPattern));
            if (relativeMappingPaths.isEmpty()) {
                logger.println(String.format("No obfuscation mapping files matching the pattern '%s' could be found; no files will be uploaded", filesPattern));
                return false;
            }
            if (relativeMappingPaths.size() == 1) {
                FilePath mappingFile = workspace.child((String)relativeMappingPaths.get(0));
                for (FilePath apk : apkFiles) {
                    apkFilesToMappingFiles.put(apk, mappingFile);
                }
            } else if (relativeMappingPaths.size() == apkFiles.size()) {
                int n = apkFiles.size();
                for (int i = 0; i < n; ++i) {
                    apkFilesToMappingFiles.put((FilePath)apkFiles.get(i), workspace.child((String)relativeMappingPaths.get(i)));
                }
            } else {
                logger.println(String.format("There are %d APKs to be uploaded, but only %d obfuscation mapping files were found matching the pattern '%s':", apkFiles.size(), relativeMappingPaths.size(), mappingFilesPattern));
                for (String path : relativePaths) {
                    logger.println(String.format("- %s", path));
                }
                for (String path : relativeMappingPaths) {
                    logger.println(String.format("- %s", path));
                }
                return false;
            }
        }
        String applicationId = (String)applicationIds.iterator().next();
        TreeMap<Integer, ExpansionFileSet> expansionFiles = new TreeMap<Integer, ExpansionFileSet>();
        String expansionPattern = this.getExpandedExpansionFilesPattern();
        if (expansionPattern != null) {
            List expansionPaths = (List)workspace.act((FilePath.FileCallable)new FindFilesTask(expansionPattern));
            for (String path : expansionPaths) {
                FilePath file = workspace.child(path);
                Matcher matcher = Constants.OBB_FILE_REGEX.matcher(file.getName());
                if (!matcher.matches()) {
                    logger.println(String.format("Expansion file '%s' doesn't match the required naming scheme", path));
                    return false;
                }
                String appId = matcher.group(3);
                if (!applicationId.equals(appId)) {
                    logger.println(String.format("Expansion filename '%s' doesn't match the application ID to be uploaded: %s", path, applicationId));
                    return false;
                }
                int versionCode = Integer.parseInt(matcher.group(2));
                if (!versionCodes.contains(versionCode)) {
                    logger.println(String.format("Expansion filename '%s' doesn't match the versionCode of any of APK(s) to be uploaded: %s", path, hudson.Util.join(versionCodes, (String)", ")));
                    return false;
                }
                String type = matcher.group(1).toLowerCase(Locale.ENGLISH);
                ExpansionFileSet fileSet = (ExpansionFileSet)expansionFiles.get(versionCode);
                if (fileSet == null) {
                    fileSet = new ExpansionFileSet();
                    expansionFiles.put(versionCode, fileSet);
                }
                if (type.equals("main")) {
                    fileSet.setMainFile(file);
                    continue;
                }
                fileSet.setPatchFile(file);
            }
            for (ExpansionFileSet fileSet : expansionFiles.values()) {
                if (this.usePreviousExpansionFilesIfMissing || fileSet.getPatchFile() == null || fileSet.getMainFile() != null) continue;
                logger.println(String.format("Patch expansion file '%s' was provided, but no main expansion file was provided, and the option to reuse a pre-existing expansion file was disabled.%nGoogle Play requires that each APK with a patch file also has a main file.", fileSet.getPatchFile().getName()));
                return false;
            }
        }
        try {
            GoogleRobotCredentials credentials = this.getCredentialsHandler().getServiceAccountCredentials();
            return (Boolean)workspace.act((Callable)new ApkUploadTask(listener, credentials, applicationId, workspace, apkFiles, apkFilesToMappingFiles, expansionFiles, this.usePreviousExpansionFilesIfMissing, ReleaseTrack.fromConfigValue(this.getCanonicalTrackName()), this.getRolloutPercentageValue(), this.getExpandedRecentChangesList()));
        }
        catch (UploadException e) {
            logger.println(String.format("Upload failed: %s", Util.getPublisherErrorMessage(e)));
            logger.println("- No changes have been applied to the Google Play account");
            return false;
        }
    }

    @Symbol(value={"androidApkUpload"})
    @Extension
    public static final class DescriptorImpl
    extends GooglePlayBuildStepDescriptor<Publisher> {
        public String getDisplayName() {
            return "Upload Android APK to Google Play";
        }
    }

    public static final class RecentChanges
    extends AbstractDescribableImpl<RecentChanges>
    implements Serializable {
        private static final long serialVersionUID = 1L;
        @Exported
        public final String language;
        @Exported
        public final String text;

        @DataBoundConstructor
        public RecentChanges(String language, String text) {
            this.language = language;
            this.text = text;
        }

        @Extension
        public static class DescriptorImpl
        extends Descriptor<RecentChanges> {
            public String getDisplayName() {
                return "Recent changes";
            }

            public ComboBoxModel doFillLanguageItems() {
                return new ComboBoxModel(Util.SUPPORTED_LANGUAGES);
            }

            public FormValidation doCheckLanguage(@QueryParameter String value) {
                if ((value = hudson.Util.fixEmptyAndTrim((String)value)) != null && !value.matches("[a-z]{2,3}([-_][0-9A-Z]{2,})?") && !value.matches("\\$([A-Za-z0-9_]+|\\{[A-Za-z0-9_]+\\}|\\$)")) {
                    return FormValidation.warning((String)"Should be a language code like 'be' or 'en-GB'");
                }
                return FormValidation.ok();
            }

            public FormValidation doCheckText(@QueryParameter String value) {
                if ((value = hudson.Util.fixEmptyAndTrim((String)value)) != null && value.length() > 500) {
                    return FormValidation.error((String)"Recent changes text must be 500 characters or fewer");
                }
                return FormValidation.ok();
            }
        }
    }

    static final class ExpansionFileSet
    implements Serializable {
        private static final long serialVersionUID = 1L;
        FilePath mainFile;
        FilePath patchFile;

        ExpansionFileSet() {
        }

        public FilePath getMainFile() {
            return this.mainFile;
        }

        public void setMainFile(FilePath mainFile) {
            this.mainFile = mainFile;
        }

        public FilePath getPatchFile() {
            return this.patchFile;
        }

        public void setPatchFile(FilePath patchFile) {
            this.patchFile = patchFile;
        }
    }
}

