/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.googleplayandroidpublisher;

import com.google.api.services.androidpublisher.AndroidPublisher;
import com.google.api.services.androidpublisher.model.AppEdit;
import com.google.jenkins.plugins.credentials.oauth.GoogleRobotCredentials;
import hudson.model.TaskListener;
import java.io.IOException;
import java.io.PrintStream;
import java.security.GeneralSecurityException;
import jenkins.security.MasterToSlaveCallable;
import org.jenkinsci.plugins.googleplayandroidpublisher.PublisherApiException;
import org.jenkinsci.plugins.googleplayandroidpublisher.UploadException;
import org.jenkinsci.plugins.googleplayandroidpublisher.Util;

public abstract class AbstractPublisherTask<V>
extends MasterToSlaveCallable<V, UploadException> {
    private final TaskListener listener;
    private final GoogleRobotCredentials credentials;
    private final String pluginVersion;
    protected AndroidPublisher.Edits editService;
    protected String editId;
    protected PrintStream logger;

    AbstractPublisherTask(TaskListener listener, GoogleRobotCredentials credentials) {
        this.listener = listener;
        this.credentials = credentials;
        this.pluginVersion = Util.getPluginVersion();
    }

    public final V call() throws UploadException {
        this.editService = this.getEditService();
        this.logger = this.listener.getLogger();
        try {
            return this.execute();
        }
        catch (IOException e) {
            throw new PublisherApiException(e);
        }
        catch (InterruptedException e) {
            throw new UploadException(e);
        }
    }

    protected abstract V execute() throws IOException, InterruptedException, UploadException;

    protected final AndroidPublisher.Edits getEditService() throws UploadException {
        try {
            return Util.getPublisherClient(this.credentials, this.pluginVersion).edits();
        }
        catch (GeneralSecurityException e) {
            throw new UploadException(e);
        }
    }

    protected final void createEdit(String applicationId) throws IOException {
        this.editId = ((AppEdit)this.editService.insert(applicationId, null).execute()).getId();
    }

    protected String getCredentialName() {
        return this.credentials.getId();
    }
}

