/*
 * Decompiled with CFR 0.152.
 */
package com.google.jenkins.plugins.k8sengine;

import com.google.api.services.container.model.Cluster;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import org.yaml.snakeyaml.Yaml;

public class KubeConfig {
    private static final String KUBECONTEXT_FORMAT = "gke_%s_%s_%s";
    private static final String KUBESERVER_FORMAT = "https://%s";
    private static final String API_VERSION = "v1";
    private static final String CONFIG_KIND = "Config";
    private ImmutableList<Object> contexts;
    private ImmutableList<Object> clusters;
    private ImmutableList<Object> users;
    private String currentContext;

    private KubeConfig() {
    }

    public ImmutableList<Object> getContexts() {
        return this.contexts;
    }

    private void setContexts(ImmutableList<Object> contexts) {
        this.contexts = (ImmutableList)Preconditions.checkNotNull(contexts);
    }

    public ImmutableList<Object> getClusters() {
        return this.clusters;
    }

    private void setClusters(ImmutableList<Object> clusters) {
        this.clusters = (ImmutableList)Preconditions.checkNotNull(clusters);
    }

    public ImmutableList<Object> getUsers() {
        return this.users;
    }

    private void setUsers(ImmutableList<Object> users) {
        this.users = (ImmutableList)Preconditions.checkNotNull(users);
    }

    public String getCurrentContext() {
        return this.currentContext;
    }

    private void setCurrentContext(String currentContext) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)currentContext) ? 1 : 0) != 0);
        this.currentContext = currentContext;
    }

    public String toYaml() throws IOException {
        return new Yaml().dumpAsMap((Object)new ImmutableMap.Builder().put((Object)"apiVersion", (Object)API_VERSION).put((Object)"kind", (Object)CONFIG_KIND).put((Object)"current-context", (Object)this.getCurrentContext()).put((Object)"clusters", this.getClusters()).put((Object)"contexts", this.getContexts()).put((Object)"users", this.getUsers()).build());
    }

    public static KubeConfig fromCluster(String projectId, Cluster cluster, String accessToken) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)projectId) ? 1 : 0) != 0);
        Preconditions.checkNotNull((Object)cluster);
        String currentContext = KubeConfig.contextString(projectId, cluster.getLocation(), cluster.getName());
        return new Builder().currentContext(currentContext).contexts((ImmutableList<Object>)ImmutableList.of(KubeConfig.context(currentContext))).users((ImmutableList<Object>)ImmutableList.of(KubeConfig.user(currentContext, cluster, accessToken))).clusters((ImmutableList<Object>)ImmutableList.of(KubeConfig.cluster(currentContext, cluster))).build();
    }

    @VisibleForTesting
    static String contextString(String project, String location, String cluster) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)project) ? 1 : 0) != 0);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)location) ? 1 : 0) != 0);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)cluster) ? 1 : 0) != 0);
        return String.format(KUBECONTEXT_FORMAT, project, location, cluster);
    }

    @VisibleForTesting
    static String clusterServer(Cluster cluster) {
        Preconditions.checkNotNull((Object)cluster);
        return String.format(KUBESERVER_FORMAT, cluster.getEndpoint());
    }

    private static ImmutableMap<String, Object> context(String currentContext) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)currentContext) ? 1 : 0) != 0);
        return new ImmutableMap.Builder().put((Object)"name", (Object)currentContext).put((Object)"context", (Object)new ImmutableMap.Builder().put((Object)"cluster", (Object)currentContext).put((Object)"user", (Object)currentContext).put((Object)"namespace", (Object)"default").build()).build();
    }

    private static ImmutableMap<String, Object> user(String currentContext, Cluster cluster, String accessToken) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)currentContext) ? 1 : 0) != 0);
        Preconditions.checkNotNull((Object)cluster);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)accessToken) ? 1 : 0) != 0);
        return new ImmutableMap.Builder().put((Object)"name", (Object)currentContext).put((Object)"user", (Object)new ImmutableMap.Builder().put((Object)"token", (Object)accessToken).build()).build();
    }

    private static ImmutableMap<String, Object> cluster(String currentContext, Cluster cluster) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)currentContext) ? 1 : 0) != 0);
        Preconditions.checkNotNull((Object)cluster);
        return new ImmutableMap.Builder().put((Object)"name", (Object)currentContext).put((Object)"cluster", (Object)new ImmutableMap.Builder().put((Object)"server", (Object)KubeConfig.clusterServer(cluster)).put((Object)"certificate-authority-data", (Object)cluster.getMasterAuth().getClusterCaCertificate()).build()).build();
    }

    public static class Builder {
        private KubeConfig config = new KubeConfig();

        public Builder currentContext(String currentContext) {
            this.config.setCurrentContext(currentContext);
            return this;
        }

        public Builder users(ImmutableList<Object> users) {
            this.config.setUsers((ImmutableList<Object>)users);
            return this;
        }

        public Builder contexts(ImmutableList<Object> contexts) {
            this.config.setContexts((ImmutableList<Object>)contexts);
            return this;
        }

        public Builder clusters(ImmutableList<Object> clusters) {
            this.config.setClusters((ImmutableList<Object>)clusters);
            return this;
        }

        public KubeConfig build() {
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)this.config.getCurrentContext()) ? 1 : 0) != 0);
            return this.config;
        }
    }
}

