/*
 * Decompiled with CFR 0.152.
 */
package com.google.jenkins.plugins.computeengine.ssh;

import com.google.jenkins.plugins.computeengine.SshConfiguration;
import com.google.jenkins.plugins.computeengine.ssh.GoogleKeyCredential;
import hudson.util.Secret;
import java.io.Serializable;

public class GooglePrivateKey
extends GoogleKeyCredential
implements Serializable {
    private final Secret privateKey;

    private GooglePrivateKey(Secret privateKey, String user) {
        super(user);
        this.privateKey = privateKey;
    }

    public static GooglePrivateKey generate(String credentialsId, String user) {
        String privateKeyStr = (String)SshConfiguration.getCustomPrivateKeyCredentials(credentialsId).getPrivateKeys().get(0);
        return new GooglePrivateKey(Secret.fromString((String)privateKeyStr), user);
    }

    @Override
    public Secret getPrivateKey() {
        return this.privateKey;
    }

    public String toString() {
        return "Private key:\n" + this.privateKey.getEncryptedValue();
    }
}

