/*
 * Decompiled with CFR 0.152.
 */
package com.google.jenkins.plugins.computeengine;

import com.cloudbees.jenkins.plugins.sshcredentials.impl.BasicSSHUserPrivateKey;
import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.SystemCredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import com.cloudbees.plugins.credentials.common.StandardUsernameCredentials;
import com.cloudbees.plugins.credentials.common.StandardUsernameListBoxModel;
import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import com.google.common.base.Strings;
import com.google.jenkins.plugins.computeengine.ComputeEngineCloud;
import hudson.Extension;
import hudson.model.Describable;
import hudson.model.Descriptor;
import hudson.model.ItemGroup;
import hudson.security.ACL;
import hudson.security.AccessControlled;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.Serializable;
import java.util.ArrayList;
import jenkins.model.Jenkins;
import org.acegisecurity.Authentication;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

public class WindowsConfiguration
implements Describable<WindowsConfiguration>,
Serializable {
    private static final long serialVersionUID = 1L;
    private String passwordCredentialsId;
    private String privateKeyCredentialsId;

    @DataBoundConstructor
    public WindowsConfiguration() {
    }

    public String getPassword() {
        if (this.passwordCredentialsId.isEmpty()) {
            return null;
        }
        StandardUsernamePasswordCredentials cred = (StandardUsernamePasswordCredentials)CredentialsMatchers.firstOrNull((Iterable)CredentialsProvider.lookupCredentials(StandardUsernamePasswordCredentials.class, (ItemGroup)Jenkins.get(), (Authentication)ACL.SYSTEM, new ArrayList()), (CredentialsMatcher)CredentialsMatchers.withId((String)this.passwordCredentialsId));
        if (cred == null) {
            return null;
        }
        return cred.getPassword().getPlainText();
    }

    public StandardUsernameCredentials getPrivateKeyCredentials() {
        if (Strings.isNullOrEmpty((String)this.privateKeyCredentialsId)) {
            return null;
        }
        return (StandardUsernameCredentials)CredentialsMatchers.firstOrNull((Iterable)new SystemCredentialsProvider.ProviderImpl().getCredentials(BasicSSHUserPrivateKey.class, (ItemGroup)Jenkins.get(), ACL.SYSTEM), (CredentialsMatcher)CredentialsMatchers.withId((String)this.privateKeyCredentialsId));
    }

    public Descriptor<WindowsConfiguration> getDescriptor() {
        return Jenkins.get().getDescriptor(WindowsConfiguration.class);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getPasswordCredentialsId() {
        return this.passwordCredentialsId;
    }

    public String getPrivateKeyCredentialsId() {
        return this.privateKeyCredentialsId;
    }

    @DataBoundSetter
    public void setPasswordCredentialsId(String passwordCredentialsId) {
        this.passwordCredentialsId = passwordCredentialsId;
    }

    @DataBoundSetter
    public void setPrivateKeyCredentialsId(String privateKeyCredentialsId) {
        this.privateKeyCredentialsId = privateKeyCredentialsId;
    }

    public WindowsConfiguration(String passwordCredentialsId, String privateKeyCredentialsId) {
        this.passwordCredentialsId = passwordCredentialsId;
        this.privateKeyCredentialsId = privateKeyCredentialsId;
    }

    public String toString() {
        return "WindowsConfiguration(passwordCredentialsId=" + this.getPasswordCredentialsId() + ", privateKeyCredentialsId=" + this.getPrivateKeyCredentialsId() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WindowsConfiguration)) {
            return false;
        }
        WindowsConfiguration other = (WindowsConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$passwordCredentialsId = this.getPasswordCredentialsId();
        String other$passwordCredentialsId = other.getPasswordCredentialsId();
        if (this$passwordCredentialsId == null ? other$passwordCredentialsId != null : !this$passwordCredentialsId.equals(other$passwordCredentialsId)) {
            return false;
        }
        String this$privateKeyCredentialsId = this.getPrivateKeyCredentialsId();
        String other$privateKeyCredentialsId = other.getPrivateKeyCredentialsId();
        return !(this$privateKeyCredentialsId == null ? other$privateKeyCredentialsId != null : !this$privateKeyCredentialsId.equals(other$privateKeyCredentialsId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof WindowsConfiguration;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $passwordCredentialsId = this.getPasswordCredentialsId();
        result = result * 59 + ($passwordCredentialsId == null ? 43 : $passwordCredentialsId.hashCode());
        String $privateKeyCredentialsId = this.getPrivateKeyCredentialsId();
        result = result * 59 + ($privateKeyCredentialsId == null ? 43 : $privateKeyCredentialsId.hashCode());
        return result;
    }

    public static class Builder {
        private String passwordCredentialsId;
        private String privateKeyCredentialsId;

        Builder() {
        }

        public Builder passwordCredentialsId(String passwordCredentialsId) {
            this.passwordCredentialsId = passwordCredentialsId;
            return this;
        }

        public Builder privateKeyCredentialsId(String privateKeyCredentialsId) {
            this.privateKeyCredentialsId = privateKeyCredentialsId;
            return this;
        }

        public WindowsConfiguration build() {
            return new WindowsConfiguration(this.passwordCredentialsId, this.privateKeyCredentialsId);
        }

        public String toString() {
            return "WindowsConfiguration.Builder(passwordCredentialsId=" + this.passwordCredentialsId + ", privateKeyCredentialsId=" + this.privateKeyCredentialsId + ")";
        }
    }

    @Extension
    public static final class DescriptorImpl
    extends Descriptor<WindowsConfiguration> {
        public ListBoxModel doFillPasswordCredentialsIdItems(@AncestorInPath Jenkins context) {
            ComputeEngineCloud.checkPermissions((AccessControlled)context, Jenkins.ADMINISTER);
            return new StandardListBoxModel().withEmptySelection().withMatching(CredentialsMatchers.instanceOf(StandardUsernamePasswordCredentials.class), (Iterable)CredentialsProvider.lookupCredentials(StandardUsernamePasswordCredentials.class, (ItemGroup)context, (Authentication)ACL.SYSTEM, new ArrayList()));
        }

        public ListBoxModel doFillPrivateKeyCredentialsIdItems(@AncestorInPath Jenkins context) {
            ComputeEngineCloud.checkPermissions((AccessControlled)context, Jenkins.ADMINISTER);
            return new StandardUsernameListBoxModel().withEmptySelection().withMatching(CredentialsMatchers.instanceOf(BasicSSHUserPrivateKey.class), (Iterable)CredentialsProvider.lookupCredentials(StandardUsernameCredentials.class, (ItemGroup)context, (Authentication)ACL.SYSTEM, new ArrayList()));
        }

        public FormValidation doCheckPrivateKeyCredentialsId(@QueryParameter String value, @QueryParameter(value="passwordCredentialsId") String passwordCredentialsId) {
            if (Strings.isNullOrEmpty((String)value) && Strings.isNullOrEmpty((String)passwordCredentialsId)) {
                return FormValidation.error((String)"A password or private key credential is required");
            }
            return FormValidation.ok();
        }
    }
}

