/*
 * Decompiled with CFR 0.152.
 */
package com.google.jenkins.plugins.computeengine;

import com.cloudbees.jenkins.plugins.sshcredentials.SSHUserPrivateKey;
import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import com.google.common.base.Strings;
import com.google.jenkins.plugins.computeengine.ComputeEngineCloud;
import hudson.Extension;
import hudson.model.Describable;
import hudson.model.Descriptor;
import hudson.model.ItemGroup;
import hudson.security.ACL;
import hudson.security.AccessControlled;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Serializable;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

public class SshConfiguration
implements Describable<SshConfiguration>,
Serializable {
    private static final Logger log = Logger.getLogger(SshConfiguration.class.getName());
    private String customPrivateKeyCredentialsId;

    @DataBoundConstructor
    public SshConfiguration() {
    }

    public static SSHUserPrivateKey getCustomPrivateKeyCredentials(String id) {
        if (Strings.isNullOrEmpty((String)id)) {
            return null;
        }
        return (SSHUserPrivateKey)CredentialsMatchers.firstOrNull((Iterable)CredentialsProvider.lookupCredentials(SSHUserPrivateKey.class, (ItemGroup)Jenkins.get(), null, Collections.emptyList()), (CredentialsMatcher)CredentialsMatchers.withId((String)id));
    }

    public Descriptor<SshConfiguration> getDescriptor() {
        return Jenkins.get().getDescriptor(SshConfiguration.class);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getCustomPrivateKeyCredentialsId() {
        return this.customPrivateKeyCredentialsId;
    }

    @DataBoundSetter
    public void setCustomPrivateKeyCredentialsId(String customPrivateKeyCredentialsId) {
        this.customPrivateKeyCredentialsId = customPrivateKeyCredentialsId;
    }

    public SshConfiguration(String customPrivateKeyCredentialsId) {
        this.customPrivateKeyCredentialsId = customPrivateKeyCredentialsId;
    }

    public String toString() {
        return "SshConfiguration(customPrivateKeyCredentialsId=" + this.getCustomPrivateKeyCredentialsId() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SshConfiguration)) {
            return false;
        }
        SshConfiguration other = (SshConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$customPrivateKeyCredentialsId = this.getCustomPrivateKeyCredentialsId();
        String other$customPrivateKeyCredentialsId = other.getCustomPrivateKeyCredentialsId();
        return !(this$customPrivateKeyCredentialsId == null ? other$customPrivateKeyCredentialsId != null : !this$customPrivateKeyCredentialsId.equals(other$customPrivateKeyCredentialsId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SshConfiguration;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $customPrivateKeyCredentialsId = this.getCustomPrivateKeyCredentialsId();
        result = result * 59 + ($customPrivateKeyCredentialsId == null ? 43 : $customPrivateKeyCredentialsId.hashCode());
        return result;
    }

    public static class Builder {
        private String customPrivateKeyCredentialsId;

        Builder() {
        }

        public Builder customPrivateKeyCredentialsId(String customPrivateKeyCredentialsId) {
            this.customPrivateKeyCredentialsId = customPrivateKeyCredentialsId;
            return this;
        }

        public SshConfiguration build() {
            return new SshConfiguration(this.customPrivateKeyCredentialsId);
        }

        public String toString() {
            return "SshConfiguration.Builder(customPrivateKeyCredentialsId=" + this.customPrivateKeyCredentialsId + ")";
        }
    }

    @Extension
    public static final class DescriptorImpl
    extends Descriptor<SshConfiguration> {
        public ListBoxModel doFillCustomPrivateKeyCredentialsIdItems(@AncestorInPath Jenkins context, @QueryParameter String customPrivateKeyCredentialsId) {
            ComputeEngineCloud.checkPermissions((AccessControlled)context, Jenkins.ADMINISTER);
            StandardListBoxModel result = new StandardListBoxModel();
            return result.includeMatchingAs(ACL.SYSTEM, (ItemGroup)context, SSHUserPrivateKey.class, new ArrayList(), CredentialsMatchers.always()).includeCurrentValue(customPrivateKeyCredentialsId);
        }

        public FormValidation doCheckCustomPrivateKeyCredentialsId(@QueryParameter String value, @QueryParameter(value="customPrivateKeyCredentialsId") String customPrivateKeyCredentialsId) throws IOException {
            String nextLine;
            ComputeEngineCloud.checkPermissions((AccessControlled)Jenkins.get(), Jenkins.ADMINISTER);
            if (Strings.isNullOrEmpty((String)value) && Strings.isNullOrEmpty((String)customPrivateKeyCredentialsId)) {
                return FormValidation.error((String)"An SSH private key credential is required");
            }
            SSHUserPrivateKey customPrivateKey = SshConfiguration.getCustomPrivateKeyCredentials(value);
            String privateKeyString = "";
            if (customPrivateKey == null) {
                return FormValidation.error((String)("Cannot find credential with name \"" + value + "\" in Global Credentials"));
            }
            privateKeyString = (String)customPrivateKey.getPrivateKeys().get(0);
            boolean hasProperStart = false;
            boolean hasProperEnd = false;
            BufferedReader br = new BufferedReader(new StringReader(privateKeyString));
            while ((nextLine = br.readLine()) != null) {
                if (nextLine.equals("-----BEGIN RSA PRIVATE KEY-----") || nextLine.equals("-----BEGIN OPENSSH PRIVATE KEY-----")) {
                    hasProperStart = true;
                }
                if (!nextLine.equals("-----END RSA PRIVATE KEY-----") && !nextLine.equals("-----END OPENSSH PRIVATE KEY-----")) continue;
                hasProperEnd = true;
            }
            if (!hasProperStart) {
                return FormValidation.error((String)"Invalid private key format (missing BEGIN key marker)");
            }
            if (!hasProperEnd) {
                return FormValidation.error((String)"Invalid private key format (missing END key marker)");
            }
            return FormValidation.ok();
        }
    }
}

