/*
 * Decompiled with CFR 0.152.
 */
package com.google.jenkins.plugins.computeengine;

import com.google.common.base.Strings;
import com.google.jenkins.plugins.computeengine.ComputeEngineCloud;
import com.google.jenkins.plugins.computeengine.NetworkConfiguration;
import hudson.Extension;
import hudson.RelativePath;
import hudson.security.AccessControlled;
import hudson.util.FormValidation;
import jenkins.model.Jenkins;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class SharedVpcNetworkConfiguration
extends NetworkConfiguration {
    public static final String SUBNETWORK_TEMPLATE = "projects/%s/regions/%s/subnetworks/%s";
    private final String projectId;
    private final String subnetworkShortName;
    private final String region;

    @DataBoundConstructor
    public SharedVpcNetworkConfiguration(String projectId, String region, String subnetworkShortName) {
        super("", String.format(SUBNETWORK_TEMPLATE, projectId, region, subnetworkShortName));
        this.projectId = projectId;
        this.subnetworkShortName = subnetworkShortName;
        this.region = region;
    }

    public String getProjectId() {
        return this.projectId;
    }

    public String getSubnetworkShortName() {
        return this.subnetworkShortName;
    }

    public String getRegion() {
        return this.region;
    }

    @Extension
    public static final class DescriptorImpl
    extends NetworkConfiguration.NetworkConfigurationDescriptor {
        @Override
        public String getDisplayName() {
            return "Shared VPC";
        }

        public FormValidation doCheckProjectId(@QueryParameter String value) {
            ComputeEngineCloud.checkPermissions((AccessControlled)Jenkins.get(), Jenkins.ADMINISTER);
            if (Strings.isNullOrEmpty((String)value)) {
                return FormValidation.error((String)"Project ID required");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckSubnetworkName(@QueryParameter String value) {
            ComputeEngineCloud.checkPermissions((AccessControlled)Jenkins.get(), Jenkins.ADMINISTER);
            if (Strings.isNullOrEmpty((String)value)) {
                return FormValidation.error((String)"Subnetwork name required");
            }
            if (value.contains("/")) {
                return FormValidation.error((String)"Subnetwork name should not contain any '/' characters");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckRegion(@QueryParameter String value, @QueryParameter(value="region") @RelativePath(value="..") String region) {
            ComputeEngineCloud.checkPermissions((AccessControlled)Jenkins.get(), Jenkins.ADMINISTER);
            if (Strings.isNullOrEmpty((String)region) || Strings.isNullOrEmpty((String)value) || !region.endsWith(value)) {
                return FormValidation.error((String)"The region you specify for a shared VPC should match the region selected in the 'Location' section above");
            }
            return FormValidation.ok();
        }
    }
}

