/*
 * Decompiled with CFR 0.152.
 */
package com.google.jenkins.plugins.computeengine;

import com.google.common.collect.ImmutableList;
import com.google.jenkins.plugins.computeengine.ComputeEngineComputer;
import com.google.jenkins.plugins.computeengine.Messages;
import hudson.model.Action;
import hudson.model.Cause;
import hudson.model.CauseAction;
import hudson.model.Executor;
import hudson.model.ExecutorListener;
import hudson.model.Job;
import hudson.model.Queue;
import hudson.security.ACL;
import hudson.security.ACLContext;
import hudson.slaves.AbstractCloudComputer;
import hudson.slaves.RetentionStrategy;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.acegisecurity.Authentication;
import org.jenkinsci.plugins.durabletask.executors.OnceRetentionStrategy;

public class ComputeEngineRetentionStrategy
extends RetentionStrategy<ComputeEngineComputer>
implements ExecutorListener {
    private static final Logger log = Logger.getLogger(ComputeEngineRetentionStrategy.class.getName());
    private final OnceRetentionStrategy delegate;
    private final boolean oneShot;

    ComputeEngineRetentionStrategy(int retentionTimeMinutes, boolean oneShot) {
        this.oneShot = oneShot;
        this.delegate = new OnceRetentionStrategy(retentionTimeMinutes);
    }

    public long check(ComputeEngineComputer c) {
        return this.delegate.check((AbstractCloudComputer)c);
    }

    public void start(ComputeEngineComputer c) {
        this.delegate.start((AbstractCloudComputer)c);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void taskAccepted(Executor executor, Queue.Task task) {
        if (this.oneShot) {
            ComputeEngineRetentionStrategy computeEngineRetentionStrategy = this;
            synchronized (computeEngineRetentionStrategy) {
                ComputeEngineComputer computer = (ComputeEngineComputer)executor.getOwner();
                if (computer.isAcceptingTasks()) {
                    computer.setAcceptingTasks(false);
                    this.delegate.taskAccepted(executor, task);
                }
            }
        }
    }

    public void taskCompleted(Executor executor, Queue.Task task, long durationMS) {
        if (this.wasPreempted(executor)) {
            this.rescheduleTask(task);
        }
        if (this.oneShot) {
            this.delegate.taskCompleted(executor, task, durationMS);
        }
    }

    public void taskCompletedWithProblems(Executor executor, Queue.Task task, long durationMS, Throwable problems) {
        if (this.wasPreempted(executor)) {
            this.rescheduleTask(task);
        }
        if (this.oneShot) {
            this.delegate.taskCompletedWithProblems(executor, task, durationMS, problems);
        }
    }

    private Queue.Task getBaseTask(Queue.Task task) {
        Queue.Task parent = task.getOwnerTask();
        while (task != parent) {
            task = parent;
            parent = task.getOwnerTask();
        }
        return parent;
    }

    private boolean wasPreempted(Executor executor) {
        ComputeEngineComputer computer = (ComputeEngineComputer)executor.getOwner();
        boolean preempted = computer.getPreempted();
        return preempted;
    }

    private void rescheduleTask(Queue.Task task) {
        Queue.Task baseTask = this.getBaseTask(task);
        log.log(Level.INFO, baseTask + " was preempted, rescheduling");
        List<Action> actions = this.generateActionsForTask(task);
        try (ACLContext notUsed = ACL.as((Authentication)task.getDefaultAuthentication());){
            Jenkins.get().getQueue().schedule2(baseTask, 0, actions);
        }
    }

    private List<Action> generateActionsForTask(Queue.Task task) {
        Queue.Task baseTask = this.getBaseTask(task);
        try {
            Job job = (Job)baseTask;
            List causes = job.getLastBuild().getCauses();
            log.log(Level.FINE, "Original causes: " + causes);
        }
        catch (Exception e) {
            log.log(Level.WARNING, "Exception for " + baseTask, e);
        }
        return ImmutableList.of((Object)new CauseAction((Cause)new Cause.UserIdCause()), (Object)new CauseAction((Cause)new RebuildCause()));
    }

    public static class RebuildCause
    extends Cause {
        public String getShortDescription() {
            return Messages.RebuildCause_ShortDescription();
        }
    }
}

