/*
 * Decompiled with CFR 0.152.
 */
package com.google.jenkins.plugins.persistentmaster.scope;

import com.google.jenkins.plugins.persistentmaster.scope.ForwardingScope;
import com.google.jenkins.plugins.persistentmaster.scope.Scope;
import com.google.jenkins.plugins.persistentmaster.volume.ForwardingVolumeCreator;
import com.google.jenkins.plugins.persistentmaster.volume.Volume;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileTime;
import java.util.Set;

public class IncrementalScope
extends ForwardingScope {
    private final FileTime lastBackupTime;

    public IncrementalScope(Scope scope, FileTime lastBackupTime) {
        super(scope);
        this.lastBackupTime = lastBackupTime;
    }

    @Override
    public void addFiles(Path jenkinsHome, Volume.Creator creator, Set<String> existingFileMetadata) throws IOException {
        super.addFiles(jenkinsHome, new ForwardingVolumeCreator(creator){

            @Override
            public void addFile(Path file, String pathInVolume, BasicFileAttributes attrs) throws IOException {
                if (attrs.lastModifiedTime().compareTo(IncrementalScope.this.lastBackupTime) > 0) {
                    super.addFile(file, pathInVolume, attrs);
                }
            }
        }, existingFileMetadata);
    }
}

