/*
 * Decompiled with CFR 0.152.
 */
package com.google.jenkins.plugins.persistentmaster.restore;

import com.google.jenkins.plugins.persistentmaster.VersionComparator;
import com.google.jenkins.plugins.persistentmaster.VersionUtility;
import com.google.jenkins.plugins.persistentmaster.initiation.InitiationStrategy;
import com.google.jenkins.plugins.persistentmaster.scope.Scope;
import com.google.jenkins.plugins.persistentmaster.storage.Storage;
import com.google.jenkins.plugins.persistentmaster.volume.Volume;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;

public class RestoreProcedure {
    private static final Logger logger = Logger.getLogger(RestoreProcedure.class.getName());
    private static final String TMP_DIR_PREFIX = "persistent-master-restore-tmp";
    private final Volume volume;
    private final Scope scope;
    private final Storage storage;
    private final InitiationStrategy initiationStrategy;
    private final Path jenkinsHome;
    private final Path scratchDir;
    private final boolean overwrite;

    public RestoreProcedure(Volume volume, Scope scope, Storage storage, InitiationStrategy initiationStrategy, Path jenkinsHome, @Nullable Path scratchDir, boolean overwrite) {
        this.volume = volume;
        this.scope = scope;
        this.storage = storage;
        this.initiationStrategy = initiationStrategy;
        this.jenkinsHome = jenkinsHome;
        this.scratchDir = scratchDir;
        this.overwrite = overwrite;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void performRestore() throws IOException {
        if (this.storage == null) {
            logger.warning("No backup location configured, initializing new environment");
            this.initiationStrategy.initializeNewEnvironment(this.jenkinsHome);
            logger.fine("Finished environment setup for jenkins");
            return;
        }
        String storageVersion = this.storage.getVersionInfo();
        String fileSystemVersion = VersionUtility.getFileSystemVersion(this.jenkinsHome);
        Map<String, Boolean> restoreFromBackupMap = this.buildRestoreFromBackupMap(storageVersion, fileSystemVersion);
        int n = restoreFromBackupMap.size();
        logger.fine(new StringBuilder(62).append("Number of files in the existing files metadata is: ").append(n).toString());
        List<String> latestBackupFiles = this.storage.findLatestBackup();
        if (latestBackupFiles == null || latestBackupFiles.isEmpty()) {
            logger.warning("No backup files found, initializing new environment");
            this.initiationStrategy.initializeNewEnvironment(this.jenkinsHome);
        } else {
            String finalBackupFile = latestBackupFiles.get(latestBackupFiles.size() - 1);
            String string = String.valueOf(finalBackupFile);
            logger.info(string.length() != 0 ? "Restoring from backup files up to: ".concat(string) : new String("Restoring from backup files up to: "));
            if (this.scratchDir != null) {
                Files.createDirectories(this.scratchDir, new FileAttribute[0]);
            }
            Path tempDirectory = this.scratchDir == null ? Files.createTempDirectory(TMP_DIR_PREFIX, new FileAttribute[0]) : Files.createTempDirectory(this.scratchDir, TMP_DIR_PREFIX, new FileAttribute[0]);
            String string2 = String.valueOf(tempDirectory);
            logger.fine(new StringBuilder(22 + String.valueOf(string2).length()).append("Using temp directory: ").append(string2).toString());
            try {
                this.parallelFetchAndExtract(latestBackupFiles, restoreFromBackupMap, tempDirectory);
            }
            finally {
                try {
                    string2 = String.valueOf(tempDirectory);
                    logger.fine(new StringBuilder(25 + String.valueOf(string2).length()).append("Deleting temp directory: ").append(string2).toString());
                    Files.deleteIfExists(tempDirectory);
                }
                catch (IOException e) {
                    logger.log(Level.FINE, "IOException while performing cleanup", e);
                }
            }
            logger.fine("Backup restored, initializing restored environment");
            this.initiationStrategy.initializeRestoredEnvironment(this.jenkinsHome, finalBackupFile);
        }
        logger.fine("Finished environment setup for jenkins");
    }

    private Map<String, Boolean> buildRestoreFromBackupMap(String storageVersion, String fileSystemVersion) throws IOException {
        HashMap<String, Boolean> restoreFromBackupMap = new HashMap<String, Boolean>();
        logger.info(new StringBuilder(47 + String.valueOf(fileSystemVersion).length() + String.valueOf(storageVersion).length()).append("FileSystem version is: ").append(fileSystemVersion).append(" and backup version is: ").append(storageVersion).toString());
        VersionComparator comparator = VersionComparator.get();
        int compare = comparator.compare(fileSystemVersion, storageVersion);
        boolean isUpgrade = compare > 0;
        for (String filename : this.storage.listMetadataForExistingFiles()) {
            restoreFromBackupMap.put(filename, !isUpgrade);
        }
        return restoreFromBackupMap;
    }

    private void parallelFetchAndExtract(List<String> latestBackupFiles, Map<String, Boolean> restoreFromBackupMap, Path tempDirectory) throws IOException {
        ForkJoinPool forkJoinPool = new ForkJoinPool();
        try {
            forkJoinPool.invoke(new FetchExtractChain(latestBackupFiles, restoreFromBackupMap, this.storage, this.volume, this.scope, tempDirectory, this.jenkinsHome, this.overwrite));
        }
        catch (RuntimeException e) {
            for (Throwable cause = e.getCause(); cause != null; cause = cause.getCause()) {
                if (!(cause instanceof IOException)) continue;
                throw (IOException)cause;
            }
            throw e;
        }
        finally {
            forkJoinPool.shutdown();
        }
    }

    private static class FetchExtractTask
    extends ForkJoinTask<Void> {
        private final FetchExtractTask previousTask;
        private final String backupFile;
        private final Map<String, Boolean> restoreFromBackupMap;
        private final Volume volume;
        private final Scope scope;
        private final Storage storage;
        private final Path jenkinsHome;
        private final Path tempDirectory;
        private final boolean overwrite;

        public FetchExtractTask(FetchExtractTask previousTask, String backupFile, Map<String, Boolean> restoreFromBackupMap, Volume volume, Scope scope, Storage storage, Path jenkinsHome, Path tempDirectory, boolean overwrite) {
            this.previousTask = previousTask;
            this.backupFile = backupFile;
            this.restoreFromBackupMap = restoreFromBackupMap;
            this.volume = volume;
            this.scope = scope;
            this.storage = storage;
            this.jenkinsHome = jenkinsHome;
            this.tempDirectory = tempDirectory;
            this.overwrite = overwrite;
        }

        @Override
        public Void getRawResult() {
            return null;
        }

        @Override
        protected void setRawResult(Void value) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected boolean exec() {
            Path volumePath = this.tempDirectory.resolve(this.backupFile);
            try {
                String string = String.valueOf(volumePath);
                logger.fine(new StringBuilder(40 + String.valueOf(string).length()).append("Fetching backup volume for backup file: ").append(string).toString());
                this.storage.loadFile(this.backupFile, volumePath);
                if (this.previousTask != null) {
                    logger.fine("Waiting for previous task to complete");
                    this.previousTask.join();
                }
                logger.fine("Extracting backup volume");
                try (Volume.Extractor extractor = this.volume.extract(volumePath);){
                    this.scope.extractFiles(this.jenkinsHome, extractor, this.overwrite, this.restoreFromBackupMap);
                }
            }
            catch (IOException e) {
                this.completeExceptionally(e);
                boolean bl = false;
                return bl;
            }
            finally {
                try {
                    Files.deleteIfExists(volumePath);
                }
                catch (IOException e) {
                    logger.log(Level.FINE, "IOException while performing cleanup", e);
                }
            }
            return true;
        }
    }

    private static class FetchExtractChain
    extends ForkJoinTask<Void> {
        private final List<String> latestBackupFiles;
        private final Map<String, Boolean> restoreFromBackupMap;
        private final Storage storage;
        private final Volume volume;
        private final Scope scope;
        private final Path tempDirectory;
        private final Path jenkinsHome;
        private final boolean overwrite;

        private FetchExtractChain(List<String> latestBackupFiles, Map<String, Boolean> restoreFromBackupMap, Storage storage, Volume volume, Scope scope, Path tempDirectory, Path jenkinsHome, boolean overwrite) {
            this.latestBackupFiles = latestBackupFiles;
            this.restoreFromBackupMap = restoreFromBackupMap;
            this.storage = storage;
            this.volume = volume;
            this.scope = scope;
            this.tempDirectory = tempDirectory;
            this.jenkinsHome = jenkinsHome;
            this.overwrite = overwrite;
        }

        @Override
        public Void getRawResult() {
            return null;
        }

        @Override
        protected void setRawResult(Void value) {
        }

        @Override
        protected boolean exec() {
            FetchExtractTask previousTask = null;
            logger.fine("Loading backup volume(s) from storage");
            Iterator<String> it = this.latestBackupFiles.iterator();
            while (it.hasNext()) {
                String file = it.next();
                FetchExtractTask fetchExtractTask = new FetchExtractTask(previousTask, file, this.restoreFromBackupMap, this.volume, this.scope, this.storage, this.jenkinsHome, this.tempDirectory, this.overwrite);
                if (it.hasNext()) {
                    fetchExtractTask.fork();
                } else {
                    fetchExtractTask.invoke();
                }
                previousTask = fetchExtractTask;
            }
            return true;
        }
    }
}

