/*
 * Decompiled with CFR 0.152.
 */
package com.google.jenkins.plugins.persistentmaster.autorestore;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Logger;

public class RestoreLog {
    private static final Logger logger = Logger.getLogger(RestoreLog.class.getName());
    private static final Object fileLock = new Object();
    private static final String SUCCESS_MESSAGE = " successfully restored at time: ";
    private static final String RESTORE_LOG_FILENAME = ".restore.log";
    private final Path logFilePath;

    public RestoreLog(Path jenkinsHome) {
        this.logFilePath = jenkinsHome.resolve(RESTORE_LOG_FILENAME);
    }

    public static Object getLock() {
        return fileLock;
    }

    public String getLastBackupId() throws IOException {
        logger.fine("Reading restore log.");
        if (!Files.exists(this.logFilePath, new LinkOption[0])) {
            logger.fine("No restore log file found.");
            return null;
        }
        if (Files.isDirectory(this.logFilePath, new LinkOption[0])) {
            String string = String.valueOf(this.logFilePath);
            throw new IllegalStateException(new StringBuilder(56 + String.valueOf(string).length()).append("Expected restore log file at: ").append(string).append(", found directory instead.").toString());
        }
        try (BufferedReader reader = Files.newBufferedReader(this.logFilePath, StandardCharsets.UTF_8);){
            String result = RestoreLog.parseLastBackupId(reader.readLine());
            if (result == null) {
                logger.fine("Could not parse last backup ID from restore log.");
                String string = null;
                return string;
            }
            String string = String.valueOf(result);
            logger.fine(string.length() != 0 ? "Parsed last backup ID from restore log: ".concat(string) : new String("Parsed last backup ID from restore log: "));
            String string2 = result;
            return string2;
        }
    }

    public void writeLastBackupId(String backupId) throws IOException {
        if (backupId == null) {
            backupId = "null";
        }
        logger.fine("Creating and writing restore log.");
        if (Files.exists(this.logFilePath, new LinkOption[0]) && Files.isDirectory(this.logFilePath, new LinkOption[0])) {
            String string = String.valueOf(this.logFilePath);
            throw new IllegalStateException(new StringBuilder(56 + String.valueOf(string).length()).append("Expected restore log file at: ").append(string).append(", found directory instead.").toString());
        }
        try (BufferedWriter writer = Files.newBufferedWriter(this.logFilePath, StandardCharsets.UTF_8, new OpenOption[0]);){
            String string = String.valueOf(backupId);
            logger.fine(string.length() != 0 ? "Writing last backup ID: ".concat(string) : new String("Writing last backup ID: "));
            writer.write(RestoreLog.getSuccessLogLine(backupId));
        }
    }

    public static String parseLastBackupId(String logLine) {
        if (logLine == null || logLine.isEmpty()) {
            return null;
        }
        int index = logLine.indexOf(SUCCESS_MESSAGE);
        if (index < 0) {
            return null;
        }
        return logLine.substring(0, index);
    }

    private static String getSuccessLogLine(String lastBackupId) {
        String string = String.valueOf(SUCCESS_MESSAGE);
        String string2 = String.valueOf(new SimpleDateFormat().format(new Date()));
        return new StringBuilder(0 + String.valueOf(lastBackupId).length() + String.valueOf(string).length() + String.valueOf(string2).length()).append(lastBackupId).append(string).append(string2).toString();
    }
}

