/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.gogs;

import hudson.Extension;
import hudson.model.Job;
import hudson.model.JobProperty;
import hudson.model.JobPropertyDescriptor;
import hudson.util.Secret;
import java.util.logging.Logger;
import net.sf.json.JSONObject;
import org.jenkinsci.plugins.gogs.GogsWebHook;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;

public class GogsProjectProperty
extends JobProperty<Job<?, ?>> {
    private final Secret gogsSecret;
    private final boolean gogsUsePayload;
    private final String gogsBranchFilter;
    private static final Logger LOGGER = Logger.getLogger(GogsWebHook.class.getName());

    @Deprecated
    public GogsProjectProperty(String gogsSecret, boolean gogsUsePayload, String gogsBranchFilter) {
        this(Secret.fromString((String)gogsSecret), gogsUsePayload, gogsBranchFilter);
    }

    @DataBoundConstructor
    public GogsProjectProperty(Secret gogsSecret, boolean gogsUsePayload, String gogsBranchFilter) {
        this.gogsSecret = gogsSecret;
        this.gogsUsePayload = gogsUsePayload;
        this.gogsBranchFilter = gogsBranchFilter;
    }

    public Secret getGogsSecret() {
        return this.gogsSecret;
    }

    public boolean getGogsUsePayload() {
        return this.gogsUsePayload;
    }

    public String getGogsBranchFilter() {
        return this.gogsBranchFilter;
    }

    public boolean getHasBranchFilter() {
        return this.gogsBranchFilter != null && this.gogsBranchFilter.length() > 0;
    }

    public boolean filterBranch(String ref) {
        if (this.gogsBranchFilter != null && this.gogsBranchFilter.length() > 0 && !this.gogsBranchFilter.equals("*")) {
            return ref == null || ref.length() == 0 || ref.endsWith(this.gogsBranchFilter);
        }
        return true;
    }

    @Extension
    public static final class DescriptorImpl
    extends JobPropertyDescriptor {
        public static final String GOGS_PROJECT_BLOCK_NAME = "gogsProject";
        private Secret gogsSecret;
        private boolean gogsUsePayload;
        private String gogsBranchFilter;

        public String getGogsSecret() {
            return Secret.toString((Secret)this.gogsSecret);
        }

        public boolean getGogsUsePayload() {
            return this.gogsUsePayload;
        }

        public String getGogsBranchFilter() {
            return this.gogsBranchFilter;
        }

        public JobProperty<?> newInstance(StaplerRequest req, JSONObject formData) {
            GogsProjectProperty tpp = null;
            if (req != null) {
                tpp = (GogsProjectProperty)((Object)req.bindJSON(GogsProjectProperty.class, formData.getJSONObject(GOGS_PROJECT_BLOCK_NAME)));
            }
            if (tpp != null) {
                LOGGER.finest(formData.toString());
                LOGGER.finest(tpp.gogsBranchFilter);
                this.gogsSecret = tpp.gogsSecret;
                this.gogsBranchFilter = tpp.gogsBranchFilter;
            }
            return tpp;
        }

        public String getDisplayName() {
            return "Gogs Project Property";
        }
    }
}

