/*
 * Decompiled with CFR 0.152.
 */
package com.dabsquared.gitlabjenkins.util;

import com.dabsquared.gitlabjenkins.gitlab.api.GitLabClient;
import java.net.URISyntaxException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jgit.transport.URIish;

public final class ProjectIdUtil {
    private static final Pattern PROJECT_ID_PATTERN = Pattern.compile("^/?(?<projectId>.*?)(\\.git)?$");

    private ProjectIdUtil() {
    }

    public static String retrieveProjectId(GitLabClient client, String remoteUrl) throws ProjectIdResolutionException {
        try {
            Matcher matcher;
            String projectId;
            String baseUri = client.getHostUrl();
            if (baseUri != null && remoteUrl.startsWith(baseUri)) {
                projectId = new URIish(remoteUrl.substring(baseUri.length())).getPath();
                if (projectId.contains(":")) {
                    projectId = projectId.substring(projectId.indexOf(":"));
                } else if (projectId.startsWith(".")) {
                    projectId = projectId.substring(projectId.indexOf("/"));
                }
            } else {
                projectId = new URIish(remoteUrl).getPath();
            }
            if (projectId.startsWith(":")) {
                projectId = projectId.substring(1);
            }
            if ((matcher = PROJECT_ID_PATTERN.matcher(projectId)).matches()) {
                return matcher.group("projectId");
            }
            throw new ProjectIdResolutionException(String.format("Failed to retrieve GitLab projectId for %s", remoteUrl));
        }
        catch (URISyntaxException e) {
            throw new ProjectIdResolutionException(String.format("Failed to retrieve GitLab projectId for %s", remoteUrl), e);
        }
    }

    public static class ProjectIdResolutionException
    extends Exception {
        public ProjectIdResolutionException(String message, Throwable cause) {
            super(message, cause);
        }

        public ProjectIdResolutionException(String message) {
            super(message);
        }
    }
}

