/*
 * Decompiled with CFR 0.152.
 */
package com.dabsquared.gitlabjenkins.trigger.handler.pipeline;

import com.dabsquared.gitlabjenkins.cause.CauseData;
import com.dabsquared.gitlabjenkins.cause.CauseDataBuilder;
import com.dabsquared.gitlabjenkins.connection.GitLabConnectionProperty;
import com.dabsquared.gitlabjenkins.gitlab.api.GitLabClient;
import com.dabsquared.gitlabjenkins.gitlab.api.model.Project;
import com.dabsquared.gitlabjenkins.gitlab.hook.model.PipelineEventObjectAttributes;
import com.dabsquared.gitlabjenkins.gitlab.hook.model.PipelineHook;
import com.dabsquared.gitlabjenkins.trigger.exception.NoRevisionToBuildException;
import com.dabsquared.gitlabjenkins.trigger.filter.BranchFilter;
import com.dabsquared.gitlabjenkins.trigger.filter.MergeRequestLabelFilter;
import com.dabsquared.gitlabjenkins.trigger.handler.AbstractWebHookTriggerHandler;
import com.dabsquared.gitlabjenkins.trigger.handler.builder.generated.BuildStatusUpdateBuilder;
import com.dabsquared.gitlabjenkins.trigger.handler.pipeline.PipelineHookTriggerHandler;
import com.dabsquared.gitlabjenkins.util.BuildUtil;
import com.dabsquared.gitlabjenkins.util.LoggerUtil;
import hudson.model.AbstractProject;
import hudson.model.Job;
import hudson.model.Run;
import hudson.plugins.git.GitSCM;
import hudson.plugins.git.RevisionParameterAction;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.WebApplicationException;

class PipelineHookTriggerHandlerImpl
extends AbstractWebHookTriggerHandler<PipelineHook>
implements PipelineHookTriggerHandler {
    private static final Logger LOGGER = Logger.getLogger(PipelineHookTriggerHandlerImpl.class.getName());
    private final List<String> allowedStates;

    PipelineHookTriggerHandlerImpl(List<String> allowedStates) {
        this.allowedStates = allowedStates;
    }

    @Override
    public void handle(Job<?, ?> job, PipelineHook hook, boolean ciSkip, BranchFilter branchFilter, MergeRequestLabelFilter mergeRequestLabelFilter) {
        PipelineEventObjectAttributes objectAttributes = hook.getObjectAttributes();
        try {
            GitLabConnectionProperty property;
            if (job instanceof AbstractProject && (property = (GitLabConnectionProperty)job.getProperty(GitLabConnectionProperty.class)) != null && property.getClient() != null) {
                GitLabClient client = property.getClient();
                Project projectForName = client.getProject(hook.getProject().getPathWithNamespace());
                hook.setProjectId(projectForName.getId());
            }
        }
        catch (WebApplicationException e) {
            LOGGER.log(Level.WARNING, "Failed to communicate with gitlab server to determine project id: " + e.getMessage(), e);
        }
        if (this.allowedStates.contains(objectAttributes.getStatus()) && !this.isLastAlreadyBuild(job, hook)) {
            String targetBranch;
            if (ciSkip && this.isCiSkip(hook)) {
                LOGGER.log(Level.INFO, "Skipping due to ci-skip.");
                return;
            }
            String sourceBranch = this.getSourceBranch(hook);
            if (branchFilter.isBranchAllowed(sourceBranch, targetBranch = this.getTargetBranch(hook))) {
                LOGGER.log(Level.INFO, "{0} triggered for {1}.", LoggerUtil.toArray(job.getFullName(), this.getTriggerType()));
                super.scheduleBuild(job, this.createActions(job, hook));
            } else {
                LOGGER.log(Level.INFO, "branch {0} is not allowed", sourceBranch + " or " + targetBranch);
            }
        }
    }

    @Override
    protected boolean isCiSkip(PipelineHook hook) {
        return false;
    }

    @Override
    protected String getSourceBranch(PipelineHook hook) {
        return hook.getObjectAttributes().getRef() == null ? null : hook.getObjectAttributes().getRef().replaceFirst("^refs/heads/", "");
    }

    @Override
    protected String getTargetBranch(PipelineHook hook) {
        return hook.getObjectAttributes().getRef() == null ? null : hook.getObjectAttributes().getRef().replaceFirst("^refs/heads/", "");
    }

    @Override
    protected String getTriggerType() {
        return "pipeline event";
    }

    @Override
    protected CauseData retrieveCauseData(PipelineHook hook) {
        return CauseDataBuilder.causeData().withActionType(CauseData.ActionType.PIPELINE).withSourceProjectId(hook.getProject().getId()).withBranch(this.getTargetBranch(hook) == null ? "" : this.getTargetBranch(hook)).withSourceBranch(this.getTargetBranch(hook) == null ? "" : this.getTargetBranch(hook)).withUserName(hook.getUser() == null || hook.getUser().getName() == null ? "" : hook.getUser().getName()).withSourceRepoName(hook.getRepository() == null || hook.getRepository().getName() == null ? "" : hook.getRepository().getName()).withSourceNamespace(hook.getProject() == null || hook.getProject().getNamespace() == null ? "" : hook.getProject().getNamespace()).withSourceRepoSshUrl(hook.getRepository() == null || hook.getRepository().getGitSshUrl() == null ? "" : hook.getRepository().getGitSshUrl()).withSourceRepoHttpUrl(hook.getRepository() == null || hook.getRepository() == null ? "" : hook.getRepository().getGitHttpUrl()).withMergeRequestTitle("").withTargetProjectId(hook.getProject().getId()).withTargetBranch(this.getTargetBranch(hook) == null ? "" : this.getTargetBranch(hook)).withTargetRepoName("").withTargetNamespace("").withTargetRepoSshUrl("").withTargetRepoHttpUrl("").withLastCommit(hook.getObjectAttributes().getSha()).withTriggeredByUser(hook.getUser() == null || hook.getUser().getName() == null ? "" : hook.getUser().getName()).withRef(hook.getObjectAttributes().getRef() == null ? "" : hook.getObjectAttributes().getRef()).withSha(hook.getObjectAttributes().getSha() == null ? "" : hook.getObjectAttributes().getSha()).withBeforeSha(hook.getObjectAttributes().getBeforeSha() == null ? "" : hook.getObjectAttributes().getBeforeSha()).withStatus(hook.getObjectAttributes().getStatus() == null ? "" : hook.getObjectAttributes().getStatus()).withStages(hook.getObjectAttributes().getStages() == null ? "" : hook.getObjectAttributes().getStages().toString()).withCreatedAt(hook.getObjectAttributes().getCreatedAt() == null ? "" : hook.getObjectAttributes().getCreatedAt().toString()).withFinishedAt(hook.getObjectAttributes().getFinishedAt() == null ? "" : hook.getObjectAttributes().getFinishedAt().toString()).withBuildDuration(String.valueOf(hook.getObjectAttributes().getDuration())).build();
    }

    @Override
    protected RevisionParameterAction createRevisionParameter(PipelineHook hook, GitSCM gitSCM) throws NoRevisionToBuildException {
        return new RevisionParameterAction(this.retrieveRevisionToBuild(hook), this.retrieveUrIish(hook));
    }

    @Override
    protected AbstractWebHookTriggerHandler.BuildStatusUpdate retrieveBuildStatusUpdate(PipelineHook hook) {
        return BuildStatusUpdateBuilder.buildStatusUpdate().withProjectId(hook.getProject().getId()).withSha(hook.getObjectAttributes().getSha()).withRef(hook.getObjectAttributes().getRef()).build();
    }

    private String retrieveRevisionToBuild(PipelineHook hook) throws NoRevisionToBuildException {
        if (hook.getObjectAttributes() != null && hook.getObjectAttributes().getSha() != null) {
            return hook.getObjectAttributes().getSha();
        }
        throw new NoRevisionToBuildException();
    }

    private boolean isLastAlreadyBuild(Job<?, ?> project, PipelineHook hook) {
        Run<?, ?> lastBuild;
        PipelineEventObjectAttributes objectAttributes = hook.getObjectAttributes();
        if (objectAttributes != null && objectAttributes.getSha() != null && (lastBuild = BuildUtil.getBuildBySHA1IncludingMergeBuilds(project, objectAttributes.getSha())) != null) {
            LOGGER.log(Level.INFO, "Last commit has already been built in build #" + lastBuild.getNumber());
            return true;
        }
        return false;
    }
}

