/*
 * Decompiled with CFR 0.152.
 */
package com.dabsquared.gitlabjenkins.publisher;

import com.dabsquared.gitlabjenkins.cause.GitLabWebHookCause;
import com.dabsquared.gitlabjenkins.connection.GitLabConnectionProperty;
import com.dabsquared.gitlabjenkins.gitlab.api.GitLabClient;
import com.dabsquared.gitlabjenkins.gitlab.api.model.MergeRequest;
import hudson.Launcher;
import hudson.matrix.MatrixAggregatable;
import hudson.matrix.MatrixAggregator;
import hudson.matrix.MatrixBuild;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Notifier;
import java.io.IOException;

public abstract class MergeRequestNotifier
extends Notifier
implements MatrixAggregatable {
    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        GitLabClient client = GitLabConnectionProperty.getClient(build);
        if (client == null) {
            listener.getLogger().println("No GitLab connection configured");
            return true;
        }
        MergeRequest mergeRequest = this.getMergeRequest((Run<?, ?>)build);
        if (mergeRequest != null) {
            this.perform((Run<?, ?>)build, (TaskListener)listener, client, mergeRequest);
        }
        return true;
    }

    public MatrixAggregator createAggregator(MatrixBuild build, Launcher launcher, BuildListener listener) {
        return new MatrixAggregator(build, launcher, listener){

            public boolean endBuild() throws InterruptedException, IOException {
                MergeRequestNotifier.this.perform((AbstractBuild<?, ?>)this.build, this.launcher, this.listener);
                return super.endBuild();
            }
        };
    }

    protected abstract void perform(Run<?, ?> var1, TaskListener var2, GitLabClient var3, MergeRequest var4);

    MergeRequest getMergeRequest(Run<?, ?> run) {
        GitLabWebHookCause cause = (GitLabWebHookCause)run.getCause(GitLabWebHookCause.class);
        return cause == null ? null : cause.getData().getMergeRequest();
    }
}

