/*
 * Decompiled with CFR 0.152.
 */
package com.dabsquared.gitlabjenkins.webhook.build;

import com.dabsquared.gitlabjenkins.GitLabPushTrigger;
import com.dabsquared.gitlabjenkins.gitlab.hook.model.MergeRequestHook;
import com.dabsquared.gitlabjenkins.gitlab.hook.model.MergeRequestObjectAttributes;
import com.dabsquared.gitlabjenkins.gitlab.hook.model.Project;
import com.dabsquared.gitlabjenkins.util.JsonUtil;
import com.dabsquared.gitlabjenkins.webhook.build.BuildWebHookAction;
import com.fasterxml.jackson.databind.JsonNode;
import hudson.model.Item;
import hudson.model.Job;
import hudson.security.ACL;
import hudson.util.HttpResponses;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.acegisecurity.Authentication;

public class MergeRequestBuildAction
extends BuildWebHookAction {
    private static final Logger LOGGER = Logger.getLogger(MergeRequestBuildAction.class.getName());
    private Item project;
    private MergeRequestHook mergeRequestHook;
    private final String secretToken;

    public MergeRequestBuildAction(Item project, String json, String secretToken) {
        LOGGER.log(Level.FINE, "MergeRequest: {0}", JsonUtil.toPrettyPrint(json));
        this.project = project;
        this.mergeRequestHook = JsonUtil.read(json, MergeRequestHook.class);
        this.secretToken = secretToken;
    }

    public MergeRequestBuildAction(Item project, JsonNode json, String secretToken) {
        LOGGER.log(Level.FINE, "MergeRequest: {0}", JsonUtil.toPrettyPrint(json));
        this.project = project;
        this.mergeRequestHook = JsonUtil.read(json, MergeRequestHook.class);
        this.secretToken = secretToken;
    }

    @Override
    void processForCompatibility() {
        MergeRequestObjectAttributes attributes = this.mergeRequestHook.getObjectAttributes();
        if (attributes != null) {
            Project source = attributes.getSource();
            if (source != null && source.getHttpUrl() != null) {
                if (source.getUrl() == null) {
                    source.setUrl(source.getHttpUrl());
                }
                if (source.getHomepage() == null) {
                    source.setHomepage(source.getHttpUrl().substring(0, source.getHttpUrl().lastIndexOf(".git")));
                }
            }
            if (this.mergeRequestHook.getProject() == null && attributes.getTarget() != null) {
                this.mergeRequestHook.setProject(attributes.getTarget());
            }
        }
    }

    @Override
    public void execute() {
        if (!(this.project instanceof Job)) {
            throw HttpResponses.errorWithoutStack((int)409, (String)"Merge Request Hook is not supported for this project");
        }
        ACL.impersonate((Authentication)ACL.SYSTEM, (Runnable)new BuildWebHookAction.TriggerNotifier(this.project, this.secretToken, Jenkins.getAuthentication()){

            @Override
            protected void performOnPost(GitLabPushTrigger trigger) {
                trigger.onPost(MergeRequestBuildAction.this.mergeRequestHook);
            }
        });
        throw HttpResponses.ok();
    }
}

