/*
 * Decompiled with CFR 0.152.
 */
package com.dabsquared.gitlabjenkins.webhook;

import com.dabsquared.gitlabjenkins.util.ACLUtil;
import com.dabsquared.gitlabjenkins.util.JsonUtil;
import com.dabsquared.gitlabjenkins.util.LoggerUtil;
import com.dabsquared.gitlabjenkins.webhook.WebHookAction;
import com.dabsquared.gitlabjenkins.webhook.build.MergeRequestBuildAction;
import com.dabsquared.gitlabjenkins.webhook.build.NoteBuildAction;
import com.dabsquared.gitlabjenkins.webhook.build.PipelineBuildAction;
import com.dabsquared.gitlabjenkins.webhook.build.PushBuildAction;
import com.dabsquared.gitlabjenkins.webhook.status.BranchBuildPageRedirectAction;
import com.dabsquared.gitlabjenkins.webhook.status.BranchStatusPngAction;
import com.dabsquared.gitlabjenkins.webhook.status.CommitBuildPageRedirectAction;
import com.dabsquared.gitlabjenkins.webhook.status.CommitStatusPngAction;
import com.dabsquared.gitlabjenkins.webhook.status.StatusJsonAction;
import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.Job;
import hudson.security.ACL;
import hudson.util.HttpResponses;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jenkins.model.Jenkins;
import jenkins.scm.api.SCMSourceOwner;
import org.apache.commons.io.IOUtils;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

public class ActionResolver {
    private static final Logger LOGGER = Logger.getLogger(ActionResolver.class.getName());
    private static final Pattern COMMIT_STATUS_PATTERN = Pattern.compile("^(refs/[^/]+/)?(commits|builds)/(?<sha1>[0-9a-fA-F]+)(?<statusJson>/status.json)?$");

    public WebHookAction resolve(String projectName, StaplerRequest request) {
        Iterator<String> restOfPathParts = Splitter.on((char)'/').omitEmptyStrings().split((CharSequence)request.getRestOfPath()).iterator();
        Item project = this.resolveProject(projectName, restOfPathParts);
        if (project == null) {
            throw HttpResponses.notFound();
        }
        return this.resolveAction(project, Joiner.on((char)'/').join(restOfPathParts), request);
    }

    private WebHookAction resolveAction(Item project, String restOfPath, StaplerRequest request) {
        String method = request.getMethod();
        if (method.equals("POST")) {
            return this.onPost(project, request);
        }
        if (method.equals("GET")) {
            if (project instanceof Job) {
                return this.onGet((Job)project, restOfPath, request);
            }
            LOGGER.log(Level.FINE, "GET is not supported for this project {0}", project.getName());
            return new NoopAction();
        }
        LOGGER.log(Level.FINE, "Unsupported HTTP method: {0}", method);
        return new NoopAction();
    }

    private WebHookAction onGet(Job<?, ?> project, String restOfPath, StaplerRequest request) {
        Matcher commitMatcher = COMMIT_STATUS_PATTERN.matcher(restOfPath);
        if (restOfPath.isEmpty() && request.hasParameter("ref")) {
            return new BranchBuildPageRedirectAction(project, request.getParameter("ref"));
        }
        if (restOfPath.endsWith("status.png")) {
            return this.onGetStatusPng(project, request);
        }
        if (commitMatcher.matches()) {
            return this.onGetCommitStatus(project, commitMatcher.group("sha1"), commitMatcher.group("statusJson"));
        }
        LOGGER.log(Level.FINE, "Unknown GET request: {0}", restOfPath);
        return new NoopAction();
    }

    private WebHookAction onGetCommitStatus(Job<?, ?> project, String sha1, String statusJson) {
        if (statusJson == null) {
            return new CommitBuildPageRedirectAction(project, sha1);
        }
        return new StatusJsonAction(project, sha1);
    }

    private WebHookAction onGetStatusPng(Job<?, ?> project, StaplerRequest request) {
        if (request.hasParameter("ref")) {
            return new BranchStatusPngAction(project, request.getParameter("ref"));
        }
        return new CommitStatusPngAction(project, request.getParameter("sha1"));
    }

    private WebHookAction onPost(Item project, StaplerRequest request) {
        String eventHeader = request.getHeader("X-Gitlab-Event");
        if (eventHeader == null) {
            LOGGER.log(Level.FINE, "Missing X-Gitlab-Event header");
            return new NoopAction();
        }
        String tokenHeader = request.getHeader("X-Gitlab-Token");
        switch (eventHeader) {
            case "Merge Request Hook": {
                return new MergeRequestBuildAction(project, this.getRequestBody(request), tokenHeader);
            }
            case "Push Hook": 
            case "Tag Push Hook": {
                return new PushBuildAction(project, this.getRequestBody(request), tokenHeader);
            }
            case "Note Hook": {
                return new NoteBuildAction(project, this.getRequestBody(request), tokenHeader);
            }
            case "Pipeline Hook": {
                return new PipelineBuildAction(project, this.getRequestBody(request), tokenHeader);
            }
            case "System Hook": {
                return this.onSystemHook(project, this.getRequestBody(request), tokenHeader);
            }
        }
        LOGGER.log(Level.FINE, "Unsupported X-Gitlab-Event header: {0}", eventHeader);
        return new NoopAction();
    }

    private WebHookAction onSystemHook(Item project, String requestBody, String tokenHeader) {
        JsonNode jsonTree = null;
        String objectKind = "";
        try {
            jsonTree = JsonUtil.readTree(requestBody);
            objectKind = jsonTree.path("object_kind").asText("");
        }
        catch (RuntimeException exception) {
            LOGGER.log(Level.FINE, "Could not extract object_kind from request body.");
        }
        switch (objectKind) {
            case "merge_request": {
                return new MergeRequestBuildAction(project, jsonTree, tokenHeader);
            }
            case "tag_push": 
            case "push": {
                return new PushBuildAction(project, jsonTree, tokenHeader);
            }
        }
        LOGGER.log(Level.FINE, "Unsupported System Hook event type: {0}", objectKind);
        return new NoopAction();
    }

    private String getRequestBody(StaplerRequest request) {
        String requestBody;
        try {
            Charset charset = request.getCharacterEncoding() == null ? StandardCharsets.UTF_8 : Charset.forName(request.getCharacterEncoding());
            requestBody = IOUtils.toString((InputStream)request.getInputStream(), (Charset)charset);
        }
        catch (IOException e) {
            throw HttpResponses.error((int)500, (String)"Failed to read request body");
        }
        return requestBody;
    }

    private Item resolveProject(final String projectName, final Iterator<String> restOfPathParts) {
        return ACLUtil.impersonate(ACL.SYSTEM, new ACLUtil.Function<Item>(){

            @Override
            public Item invoke() {
                Jenkins jenkins = Jenkins.getInstance();
                if (jenkins != null) {
                    Item item = jenkins.getItemByFullName(projectName);
                    while (item instanceof ItemGroup && !(item instanceof Job) && !(item instanceof SCMSourceOwner) && restOfPathParts.hasNext()) {
                        item = jenkins.getItem((String)restOfPathParts.next(), (ItemGroup)item);
                    }
                    if (item instanceof Job || item instanceof SCMSourceOwner) {
                        return item;
                    }
                }
                LOGGER.log(Level.FINE, "No project found: {0}, {1}", LoggerUtil.toArray(projectName, Joiner.on((char)'/').join(restOfPathParts)));
                return null;
            }
        });
    }

    static class NoopAction
    implements WebHookAction {
        NoopAction() {
        }

        @Override
        public void execute(StaplerResponse response) {
        }
    }
}

