/*
 * Decompiled with CFR 0.152.
 */
package com.dabsquared.gitlabjenkins.util;

import com.dabsquared.gitlabjenkins.cause.CauseData;
import com.dabsquared.gitlabjenkins.cause.GitLabWebHookCause;
import com.dabsquared.gitlabjenkins.connection.GitLabConnectionProperty;
import com.dabsquared.gitlabjenkins.gitlab.api.GitLabClient;
import com.dabsquared.gitlabjenkins.gitlab.api.model.BuildState;
import com.dabsquared.gitlabjenkins.util.ProjectIdUtil;
import com.dabsquared.gitlabjenkins.workflow.GitLabBranchBuild;
import hudson.EnvVars;
import hudson.model.Cause;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.plugins.git.Revision;
import hudson.plugins.git.util.Build;
import hudson.plugins.git.util.BuildData;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.WebApplicationException;
import jenkins.plugins.git.AbstractGitSCMSource;
import jenkins.scm.api.SCMRevision;
import jenkins.scm.api.SCMRevisionAction;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.jenkinsci.plugins.displayurlapi.DisplayURLProvider;

public class CommitStatusUpdater {
    private static final Logger LOGGER = Logger.getLogger(CommitStatusUpdater.class.getName());

    public static void updateCommitStatus(Run<?, ?> build, TaskListener listener, BuildState state, String name, List<GitLabBranchBuild> gitLabBranchBuilds, GitLabConnectionProperty connection) {
        GitLabClient client = connection != null ? connection.getClient() : GitLabConnectionProperty.getClient(build);
        if (client == null) {
            CommitStatusUpdater.println(listener, "No GitLab connection configured");
            return;
        }
        if (gitLabBranchBuilds == null || gitLabBranchBuilds.isEmpty()) {
            try {
                gitLabBranchBuilds = CommitStatusUpdater.retrieveGitlabProjectIds(build, build.getEnvironment(listener));
            }
            catch (IOException | InterruptedException e) {
                CommitStatusUpdater.printf(listener, "Failed to get Gitlab Build list to update status: %s%n", e.getMessage());
            }
        }
        String buildUrl = CommitStatusUpdater.getBuildUrl(build);
        for (GitLabBranchBuild gitLabBranchBuild : gitLabBranchBuilds) {
            try {
                GitLabClient build_specific_client;
                GitLabClient current_client = client;
                if (gitLabBranchBuild.getConnection() != null && (build_specific_client = gitLabBranchBuild.getConnection().getClient()) != null) {
                    current_client = build_specific_client;
                }
                String current_build_name = name;
                if (gitLabBranchBuild.getName() != null) {
                    current_build_name = gitLabBranchBuild.getName();
                }
                if (!CommitStatusUpdater.existsCommit(current_client, gitLabBranchBuild.getProjectId(), gitLabBranchBuild.getRevisionHash())) continue;
                LOGGER.log(Level.INFO, String.format("Updating build '%s' to '%s'", new Object[]{gitLabBranchBuild.getProjectId(), state}));
                current_client.changeBuildStatus(gitLabBranchBuild.getProjectId(), gitLabBranchBuild.getRevisionHash(), state, CommitStatusUpdater.getBuildBranchOrTag(build), current_build_name, buildUrl, state.name());
            }
            catch (ProcessingException | WebApplicationException e) {
                CommitStatusUpdater.printf(listener, "Failed to update Gitlab commit status for project '%s': %s%n", gitLabBranchBuild.getProjectId(), e.getMessage());
                LOGGER.log(Level.SEVERE, String.format("Failed to update Gitlab commit status for project '%s'", gitLabBranchBuild.getProjectId()), e);
            }
        }
    }

    public static void updateCommitStatus(Run<?, ?> build, TaskListener listener, BuildState state, String name) {
        try {
            CommitStatusUpdater.updateCommitStatus(build, listener, state, name, null, null);
        }
        catch (IllegalStateException e) {
            CommitStatusUpdater.printf(listener, "Failed to update Gitlab commit status: %s%n", e.getMessage());
        }
    }

    private static void println(TaskListener listener, String message) {
        if (listener == null) {
            LOGGER.log(Level.FINE, "failed to print message {0} due to null TaskListener", message);
        } else {
            listener.getLogger().println(message);
        }
    }

    private static void printf(TaskListener listener, String message, Object ... args) {
        if (listener == null) {
            LOGGER.log(Level.FINE, "failed to print message {0} due to null TaskListener", String.format(message, args));
        } else {
            listener.getLogger().printf(message, args);
        }
    }

    private static boolean existsCommit(GitLabClient client, String gitlabProjectId, String commitHash) {
        try {
            client.getCommit(gitlabProjectId, commitHash);
            return true;
        }
        catch (NotFoundException e) {
            LOGGER.log(Level.FINE, String.format("Project (%s) and commit (%s) combination not found", gitlabProjectId, commitHash));
            return false;
        }
    }

    private static String getBuildBranchOrTag(Run<?, ?> build) {
        GitLabWebHookCause cause = (GitLabWebHookCause)build.getCause(GitLabWebHookCause.class);
        if (cause == null) {
            return null;
        }
        if (cause.getData().getActionType() == CauseData.ActionType.TAG_PUSH) {
            return StringUtils.removeStart((String)cause.getData().getSourceBranch(), (String)"refs/tags/");
        }
        return cause.getData().getSourceBranch();
    }

    private static String getBuildUrl(Run<?, ?> build) {
        return DisplayURLProvider.get().getRunURL(build);
    }

    private static List<GitLabBranchBuild> retrieveGitlabProjectIds(Run<?, ?> build, EnvVars environment) {
        LOGGER.log(Level.INFO, "Retrieving gitlab project ids");
        ArrayList<GitLabBranchBuild> result = new ArrayList<GitLabBranchBuild>();
        GitLabWebHookCause gitlabCause = (GitLabWebHookCause)build.getCause(GitLabWebHookCause.class);
        if (gitlabCause != null) {
            return Collections.singletonList(new GitLabBranchBuild(gitlabCause.getData().getSourceProjectId().toString(), gitlabCause.getData().getLastCommit()));
        }
        List<GitLabBranchBuild> builds = CommitStatusUpdater.findBuildsFromUpstreamCauses(build.getCauses());
        if (!builds.isEmpty()) {
            return builds;
        }
        GitLabClient gitLabClient = GitLabConnectionProperty.getClient(build);
        if (gitLabClient == null) {
            LOGGER.log(Level.WARNING, "No gitlab client found.");
            return result;
        }
        List buildDatas = build.getActions(BuildData.class);
        if (CollectionUtils.isEmpty((Collection)buildDatas)) {
            LOGGER.log(Level.INFO, "Build does not contain build data.");
            return result;
        }
        if (buildDatas.size() == 1) {
            CommitStatusUpdater.addGitLabBranchBuild(result, CommitStatusUpdater.getBuildRevision(build), ((BuildData)buildDatas.get(0)).getRemoteUrls(), environment, gitLabClient);
        } else {
            SCMRevisionAction scmRevisionAction = (SCMRevisionAction)build.getAction(SCMRevisionAction.class);
            if (scmRevisionAction == null) {
                LOGGER.log(Level.INFO, "Build does not contain SCM revision action.");
                return result;
            }
            SCMRevision scmRevision = scmRevisionAction.getRevision();
            String scmRevisionHash = null;
            if (scmRevision instanceof AbstractGitSCMSource.SCMRevisionImpl) {
                scmRevisionHash = ((AbstractGitSCMSource.SCMRevisionImpl)scmRevision).getHash();
            }
            for (BuildData buildData : buildDatas) {
                for (Map.Entry buildByBranchName : buildData.getBuildsByBranchName().entrySet()) {
                    if (!((Build)buildByBranchName.getValue()).getSHA1().equals((AnyObjectId)ObjectId.fromString((String)scmRevisionHash))) continue;
                    CommitStatusUpdater.addGitLabBranchBuild(result, scmRevisionHash, buildData.getRemoteUrls(), environment, gitLabClient);
                }
            }
        }
        return result;
    }

    private static String getBuildRevision(Run<?, ?> build) {
        GitLabWebHookCause cause = (GitLabWebHookCause)build.getCause(GitLabWebHookCause.class);
        if (cause != null) {
            return cause.getData().getLastCommit();
        }
        BuildData action = (BuildData)build.getAction(BuildData.class);
        if (action == null) {
            throw new IllegalStateException("No (git-plugin) BuildData associated to current build");
        }
        Revision lastBuiltRevision = action.getLastBuiltRevision();
        if (lastBuiltRevision == null) {
            throw new IllegalStateException("Last build has no associated commit");
        }
        return action.getLastBuild(lastBuiltRevision.getSha1()).getMarked().getSha1String();
    }

    private static void addGitLabBranchBuild(List<GitLabBranchBuild> result, String scmRevisionHash, Set<String> remoteUrls, EnvVars environment, GitLabClient gitLabClient) {
        for (String remoteUrl : remoteUrls) {
            try {
                LOGGER.log(Level.INFO, "Retrieving the gitlab project id from remote url {0}", remoteUrl);
                String projectNameWithNameSpace = ProjectIdUtil.retrieveProjectId(gitLabClient, environment.expand(remoteUrl));
                if (!StringUtils.isNotBlank((String)projectNameWithNameSpace)) continue;
                String projectId = projectNameWithNameSpace;
                if (projectNameWithNameSpace.contains(".")) {
                    try {
                        projectId = gitLabClient.getProject(projectNameWithNameSpace).getId().toString();
                    }
                    catch (ProcessingException | WebApplicationException e) {
                        LOGGER.log(Level.SEVERE, String.format("Failed to retrieve projectId for project '%s'", projectNameWithNameSpace), e);
                    }
                }
                result.add(new GitLabBranchBuild(projectId, scmRevisionHash));
            }
            catch (ProjectIdUtil.ProjectIdResolutionException e) {
                LOGGER.log(Level.WARNING, "Did not match project id in remote url.");
            }
        }
    }

    private static List<GitLabBranchBuild> findBuildsFromUpstreamCauses(List<Cause> causes) {
        for (Cause cause : causes) {
            if (!(cause instanceof Cause.UpstreamCause)) continue;
            List upCauses = ((Cause.UpstreamCause)cause).getUpstreamCauses();
            for (Cause upCause : upCauses) {
                if (!(upCause instanceof GitLabWebHookCause)) continue;
                GitLabWebHookCause gitlabCause = (GitLabWebHookCause)upCause;
                return Collections.singletonList(new GitLabBranchBuild(gitlabCause.getData().getSourceProjectId().toString(), gitlabCause.getData().getLastCommit()));
            }
            List<GitLabBranchBuild> builds = CommitStatusUpdater.findBuildsFromUpstreamCauses(upCauses);
            if (builds.isEmpty()) continue;
            return builds;
        }
        return Collections.emptyList();
    }
}

