/*
 * Decompiled with CFR 0.152.
 */
package com.dabsquared.gitlabjenkins.connection;

import com.cloudbees.plugins.credentials.Credentials;
import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.common.AbstractIdCredentialsListBoxModel;
import com.cloudbees.plugins.credentials.common.StandardCredentials;
import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import com.cloudbees.plugins.credentials.domains.URIRequirementBuilder;
import com.dabsquared.gitlabjenkins.connection.GitLabApiToken;
import com.dabsquared.gitlabjenkins.connection.GitLabConnection;
import com.dabsquared.gitlabjenkins.connection.Messages;
import com.dabsquared.gitlabjenkins.gitlab.api.GitLabClient;
import com.dabsquared.gitlabjenkins.gitlab.api.GitLabClientBuilder;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.security.ACL;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.WebApplicationException;
import jenkins.model.GlobalConfiguration;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.eclipse.jgit.util.StringUtils;
import org.jenkinsci.plugins.plaincredentials.StringCredentials;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.DoNotUse;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.interceptor.RequirePOST;

@Extension
public class GitLabConnectionConfig
extends GlobalConfiguration {
    private Boolean useAuthenticatedEndpoint = true;
    private List<GitLabConnection> connections = new ArrayList<GitLabConnection>();
    private transient Map<String, GitLabConnection> connectionMap = new HashMap<String, GitLabConnection>();

    public GitLabConnectionConfig() {
        this.load();
        this.refreshConnectionMap();
    }

    public boolean configure(StaplerRequest req, JSONObject json) throws Descriptor.FormException {
        this.connections = req.bindJSONToList(GitLabConnection.class, json.get("connections"));
        this.useAuthenticatedEndpoint = json.getBoolean("useAuthenticatedEndpoint");
        this.refreshConnectionMap();
        this.save();
        return super.configure(req, json);
    }

    public boolean isUseAuthenticatedEndpoint() {
        return this.useAuthenticatedEndpoint;
    }

    void setUseAuthenticatedEndpoint(boolean useAuthenticatedEndpoint) {
        this.useAuthenticatedEndpoint = useAuthenticatedEndpoint;
    }

    public List<GitLabConnection> getConnections() {
        return this.connections;
    }

    public void addConnection(GitLabConnection connection) {
        this.connections.add(connection);
        this.connectionMap.put(connection.getName(), connection);
    }

    public void setConnections(List<GitLabConnection> newConnections) {
        this.connections = new ArrayList<GitLabConnection>();
        this.connectionMap = new HashMap<String, GitLabConnection>();
        for (GitLabConnection connection : newConnections) {
            this.addConnection(connection);
        }
    }

    public GitLabClient getClient(String connectionName) {
        if (!this.connectionMap.containsKey(connectionName)) {
            return null;
        }
        return this.connectionMap.get(connectionName).getClient();
    }

    public FormValidation doCheckName(@QueryParameter String id, @QueryParameter String value) {
        if (StringUtils.isEmptyOrNull((String)value)) {
            return FormValidation.error((String)Messages.name_required());
        }
        if (this.connectionMap.containsKey(value) && !this.connectionMap.get(value).toString().equals(id)) {
            return FormValidation.error((String)Messages.name_exists(value));
        }
        return FormValidation.ok();
    }

    public FormValidation doCheckUrl(@QueryParameter String value) {
        if (StringUtils.isEmptyOrNull((String)value)) {
            return FormValidation.error((String)Messages.url_required());
        }
        return FormValidation.ok();
    }

    public FormValidation doCheckApiTokenId(@QueryParameter String value) {
        if (StringUtils.isEmptyOrNull((String)value)) {
            return FormValidation.error((String)Messages.apiToken_required());
        }
        return FormValidation.ok();
    }

    public FormValidation doCheckConnectionTimeout(@QueryParameter Integer value) {
        if (value == null) {
            return FormValidation.error((String)Messages.connectionTimeout_required());
        }
        return FormValidation.ok();
    }

    public FormValidation doCheckReadTimeout(@QueryParameter Integer value) {
        if (value == null) {
            return FormValidation.error((String)Messages.readTimeout_required());
        }
        return FormValidation.ok();
    }

    @RequirePOST
    @Restricted(value={DoNotUse.class})
    public FormValidation doTestConnection(@QueryParameter String url, @QueryParameter String apiTokenId, @QueryParameter String clientBuilderId, @QueryParameter boolean ignoreCertificateErrors, @QueryParameter int connectionTimeout, @QueryParameter int readTimeout) {
        Jenkins.getActiveInstance().checkPermission(Jenkins.ADMINISTER);
        try {
            new GitLabConnection("", url, apiTokenId, clientBuilderId, ignoreCertificateErrors, (Integer)connectionTimeout, (Integer)readTimeout).getClient().getCurrentUser();
            return FormValidation.ok((String)Messages.connection_success());
        }
        catch (WebApplicationException e) {
            return FormValidation.error((String)Messages.connection_error(e.getMessage()));
        }
        catch (ProcessingException e) {
            return FormValidation.error((String)Messages.connection_error(e.getCause().getMessage()));
        }
    }

    public ListBoxModel doFillApiTokenIdItems(@QueryParameter String name, @QueryParameter String url) {
        if (Jenkins.getInstance().hasPermission(Item.CONFIGURE)) {
            AbstractIdCredentialsListBoxModel options = new StandardListBoxModel().includeEmptyValue().includeMatchingAs(ACL.SYSTEM, (ItemGroup)Jenkins.getActiveInstance(), StandardCredentials.class, URIRequirementBuilder.fromUri((String)url).build(), (CredentialsMatcher)new GitLabCredentialMatcher());
            if (name != null && this.connectionMap.containsKey(name)) {
                String apiTokenId = this.connectionMap.get(name).getApiTokenId();
                options.includeCurrentValue(apiTokenId);
                for (ListBoxModel.Option option : options) {
                    if (!option.value.equals(apiTokenId)) continue;
                    option.selected = true;
                }
            }
            return options;
        }
        return new StandardListBoxModel();
    }

    public ListBoxModel doFillClientBuilderIdItems() {
        ListBoxModel model = new ListBoxModel();
        for (GitLabClientBuilder builder : GitLabClientBuilder.getAllGitLabClientBuilders()) {
            model.add(builder.id());
        }
        return model;
    }

    private void refreshConnectionMap() {
        this.connectionMap.clear();
        for (GitLabConnection connection : this.connections) {
            this.connectionMap.put(connection.getName(), connection);
        }
    }

    protected GitLabConnectionConfig readResolve() {
        if (this.useAuthenticatedEndpoint == null) {
            this.setUseAuthenticatedEndpoint(false);
        }
        return this;
    }

    private static class GitLabCredentialMatcher
    implements CredentialsMatcher {
        private GitLabCredentialMatcher() {
        }

        public boolean matches(@NonNull Credentials credentials) {
            try {
                return credentials instanceof GitLabApiToken || credentials instanceof StringCredentials;
            }
            catch (Throwable e) {
                return false;
            }
        }
    }
}

