/*
 * Decompiled with CFR 0.152.
 */
package com.dabsquared.gitlabjenkins.trigger.handler.merge;

import com.dabsquared.gitlabjenkins.MergeRequestTriggerConfig;
import com.dabsquared.gitlabjenkins.gitlab.hook.model.Action;
import com.dabsquared.gitlabjenkins.gitlab.hook.model.State;
import com.dabsquared.gitlabjenkins.trigger.TriggerOpenMergeRequest;
import com.dabsquared.gitlabjenkins.trigger.handler.merge.MergeRequestHookTriggerHandler;
import com.dabsquared.gitlabjenkins.trigger.handler.merge.MergeRequestHookTriggerHandlerImpl;
import com.dabsquared.gitlabjenkins.trigger.handler.merge.TriggerConfigChain;
import java.util.EnumSet;

public final class MergeRequestHookTriggerHandlerFactory {
    private MergeRequestHookTriggerHandlerFactory() {
    }

    public static MergeRequestHookTriggerHandler newMergeRequestHookTriggerHandler(boolean triggerOnMergeRequest, boolean triggerOnAcceptedMergeRequest, boolean triggerOnClosedMergeRequest, TriggerOpenMergeRequest triggerOpenMergeRequest, boolean skipWorkInProgressMergeRequest, boolean triggerOnApprovedMergeRequest, boolean cancelPendingBuildsOnUpdate) {
        TriggerConfigChain chain = new TriggerConfigChain();
        chain.acceptOnlyIf(triggerOnApprovedMergeRequest, null, EnumSet.of(Action.approved)).acceptIf(triggerOnMergeRequest, EnumSet.of(State.opened, State.reopened), null).acceptIf(triggerOnAcceptedMergeRequest, null, EnumSet.of(Action.merge)).acceptIf(triggerOnClosedMergeRequest, null, EnumSet.of(Action.closed)).acceptIf(triggerOpenMergeRequest != TriggerOpenMergeRequest.never, EnumSet.of(State.updated), null);
        return new MergeRequestHookTriggerHandlerImpl(chain, skipWorkInProgressMergeRequest, cancelPendingBuildsOnUpdate);
    }

    public static MergeRequestHookTriggerHandler newMergeRequestHookTriggerHandler(MergeRequestTriggerConfig config) {
        return MergeRequestHookTriggerHandlerFactory.newMergeRequestHookTriggerHandler(config.getTriggerOnMergeRequest(), config.isTriggerOnAcceptedMergeRequest(), config.isTriggerOnClosedMergeRequest(), config.getTriggerOpenMergeRequestOnPush(), config.isSkipWorkInProgressMergeRequest(), config.isTriggerOnApprovedMergeRequest(), config.getCancelPendingBuildsOnUpdate());
    }

    public static Config withConfig() {
        return new Config();
    }

    public static class Config
    implements MergeRequestTriggerConfig {
        private boolean triggerOnMergeRequest = true;
        private boolean triggerOnAcceptedMergeRequest = false;
        private boolean triggerOnClosedMergeRequest = false;
        private TriggerOpenMergeRequest triggerOpenMergeRequest = TriggerOpenMergeRequest.never;
        private boolean skipWorkInProgressMergeRequest = false;
        private boolean triggerOnApprovedMergeRequest = false;
        private boolean cancelPendingBuildsOnUpdate = false;

        @Override
        public boolean getTriggerOnMergeRequest() {
            return this.triggerOnMergeRequest;
        }

        @Override
        public boolean isTriggerOnAcceptedMergeRequest() {
            return this.triggerOnAcceptedMergeRequest;
        }

        @Override
        public boolean isTriggerOnApprovedMergeRequest() {
            return this.triggerOnApprovedMergeRequest;
        }

        @Override
        public boolean isTriggerOnClosedMergeRequest() {
            return this.triggerOnClosedMergeRequest;
        }

        @Override
        public TriggerOpenMergeRequest getTriggerOpenMergeRequestOnPush() {
            return this.triggerOpenMergeRequest;
        }

        @Override
        public boolean isSkipWorkInProgressMergeRequest() {
            return this.skipWorkInProgressMergeRequest;
        }

        @Override
        public boolean getCancelPendingBuildsOnUpdate() {
            return this.cancelPendingBuildsOnUpdate;
        }

        public Config setTriggerOnMergeRequest(boolean triggerOnMergeRequest) {
            this.triggerOnMergeRequest = triggerOnMergeRequest;
            return this;
        }

        public Config setTriggerOnAcceptedMergeRequest(boolean triggerOnAcceptedMergeRequest) {
            this.triggerOnAcceptedMergeRequest = triggerOnAcceptedMergeRequest;
            return this;
        }

        public Config setTriggerOnClosedMergeRequest(boolean triggerOnClosedMergeRequest) {
            this.triggerOnClosedMergeRequest = triggerOnClosedMergeRequest;
            return this;
        }

        public Config setTriggerOpenMergeRequest(TriggerOpenMergeRequest triggerOpenMergeRequest) {
            this.triggerOpenMergeRequest = triggerOpenMergeRequest;
            return this;
        }

        public Config setSkipWorkInProgressMergeRequest(boolean skipWorkInProgressMergeRequest) {
            this.skipWorkInProgressMergeRequest = skipWorkInProgressMergeRequest;
            return this;
        }

        public Config setTriggerOnApprovedMergeRequest(boolean triggerOnApprovedMergeRequest) {
            this.triggerOnApprovedMergeRequest = triggerOnApprovedMergeRequest;
            return this;
        }

        public Config setCancelPendingBuildsOnUpdate(boolean cancelPendingBuildsOnUpdate) {
            this.cancelPendingBuildsOnUpdate = cancelPendingBuildsOnUpdate;
            return this;
        }

        public MergeRequestHookTriggerHandler build() {
            return MergeRequestHookTriggerHandlerFactory.newMergeRequestHookTriggerHandler(this);
        }
    }
}

