/*
 * Decompiled with CFR 0.152.
 */
package com.dabsquared.gitlabjenkins.trigger.filter;

import com.dabsquared.gitlabjenkins.trigger.filter.MergeRequestLabelFilter;
import com.google.common.base.Splitter;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

class MergeRequestLabelFilterImpl
implements MergeRequestLabelFilter {
    private final Set<String> includeLabels;
    private final Set<String> excludeLabels;

    public MergeRequestLabelFilterImpl(String includeLabels, String excludeLabels) {
        this.includeLabels = this.convert(includeLabels);
        this.excludeLabels = this.convert(excludeLabels);
    }

    @Override
    public boolean isMergeRequestAllowed(Collection<String> labels) {
        return this.containsNoExcludeLabel(labels) && this.containsIncludeLabel(labels);
    }

    private boolean containsNoExcludeLabel(Collection<String> labels) {
        for (String excludeLabel : this.excludeLabels) {
            if (labels == null || !labels.contains(excludeLabel)) continue;
            return false;
        }
        return true;
    }

    private boolean containsIncludeLabel(Collection<String> labels) {
        for (String includeLabel : this.includeLabels) {
            if (labels == null || !labels.contains(includeLabel)) continue;
            return true;
        }
        return this.includeLabels.isEmpty();
    }

    private Set<String> convert(String commaSeparatedString) {
        HashSet<String> result = new HashSet<String>();
        for (String s : Splitter.on((char)',').omitEmptyStrings().trimResults().split((CharSequence)commaSeparatedString)) {
            result.add(s);
        }
        return result;
    }
}

