/*
 * Decompiled with CFR 0.152.
 */
package com.dabsquared.gitlabjenkins.connection;

import com.dabsquared.gitlabjenkins.connection.GitLabConnection;
import com.dabsquared.gitlabjenkins.connection.GitLabConnectionConfig;
import com.dabsquared.gitlabjenkins.gitlab.api.GitLabClient;
import hudson.Extension;
import hudson.model.Descriptor;
import hudson.model.Job;
import hudson.model.JobProperty;
import hudson.model.JobPropertyDescriptor;
import hudson.model.Run;
import hudson.util.ListBoxModel;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;

public class GitLabConnectionProperty
extends JobProperty<Job<?, ?>> {
    private String gitLabConnection;

    @DataBoundConstructor
    public GitLabConnectionProperty(String gitLabConnection) {
        this.gitLabConnection = gitLabConnection;
    }

    public String getGitLabConnection() {
        return this.gitLabConnection;
    }

    public GitLabClient getClient() {
        if (StringUtils.isNotEmpty((String)this.gitLabConnection)) {
            GitLabConnectionConfig connectionConfig = (GitLabConnectionConfig)Jenkins.getInstance().getDescriptor(GitLabConnectionConfig.class);
            return connectionConfig != null ? connectionConfig.getClient(this.gitLabConnection) : null;
        }
        return null;
    }

    public static GitLabClient getClient(Run<?, ?> build) {
        GitLabConnectionProperty connectionProperty = (GitLabConnectionProperty)build.getParent().getProperty(GitLabConnectionProperty.class);
        if (connectionProperty != null) {
            return connectionProperty.getClient();
        }
        return null;
    }

    @Extension
    @Symbol(value={"gitLabConnection"})
    public static class DescriptorImpl
    extends JobPropertyDescriptor {
        public String getDisplayName() {
            return "GitLab connection";
        }

        public boolean isApplicable(Class<? extends Job> jobType) {
            return true;
        }

        public JobProperty<?> newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            return (JobProperty)req.bindJSON(GitLabConnectionProperty.class, formData);
        }

        public ListBoxModel doFillGitLabConnectionItems() {
            ListBoxModel options = new ListBoxModel();
            GitLabConnectionConfig descriptor = (GitLabConnectionConfig)Jenkins.getInstance().getDescriptor(GitLabConnectionConfig.class);
            for (GitLabConnection connection : descriptor.getConnections()) {
                options.add(connection.getName(), connection.getName());
            }
            return options;
        }
    }
}

