/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.github_branch_source;

import edu.umd.cs.findbugs.annotations.NonNull;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.github_branch_source.GitHubConfiguration;

class GitHubRepositoryInfo {
    private static final String GITHUB_API_URL = "api.github.com";
    @NonNull
    private final String apiUri;
    @NonNull
    private final String repoOwner;
    @NonNull
    private final String repository;
    @NonNull
    private final String repositoryUrl;

    private GitHubRepositoryInfo(String apiUri, String repoOwner, String repository, String repositoryUrl) {
        this.apiUri = apiUri;
        this.repoOwner = repoOwner;
        this.repository = repository;
        this.repositoryUrl = repositoryUrl;
    }

    public String getApiUri() {
        return this.apiUri;
    }

    public String getRepoOwner() {
        return this.repoOwner;
    }

    public String getRepository() {
        return this.repository;
    }

    public String getRepositoryUrl() {
        return this.repositoryUrl;
    }

    @NonNull
    public static GitHubRepositoryInfo forRepositoryUrl(@NonNull String repositoryUrl) {
        URL url;
        String trimmedRepoUrl = repositoryUrl.trim();
        if (StringUtils.isBlank((String)trimmedRepoUrl)) {
            throw new IllegalArgumentException("Repository URL must not be empty");
        }
        try {
            url = new URL(trimmedRepoUrl);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(e);
        }
        if (!url.getProtocol().equals("http") && !url.getProtocol().equals("https")) {
            throw new IllegalArgumentException("Invalid repository URL scheme (must be HTTPS or HTTP): " + url.getProtocol());
        }
        String apiUri = GitHubRepositoryInfo.guessApiUri(url);
        String[] pathParts = StringUtils.removeStart((String)url.getPath(), (String)"/").split("/");
        if (pathParts.length != 2) {
            throw new IllegalArgumentException("Invalid repository URL: " + repositoryUrl);
        }
        String repoOwner = pathParts[0];
        String repository = StringUtils.removeEnd((String)pathParts[1], (String)".git");
        return new GitHubRepositoryInfo(apiUri, repoOwner, repository, repositoryUrl.trim());
    }

    private static String guessApiUri(URL repositoryUrl) {
        StringBuilder sb = new StringBuilder();
        sb.append(repositoryUrl.getProtocol());
        sb.append("://");
        boolean isGitHub = "github.com".equals(repositoryUrl.getHost());
        if (isGitHub) {
            sb.append(GITHUB_API_URL);
        } else {
            sb.append(repositoryUrl.getHost());
        }
        if (repositoryUrl.getPort() != -1) {
            sb.append(':');
            sb.append(repositoryUrl.getPort());
        }
        if (!isGitHub) {
            sb.append('/').append("api/v3");
        }
        return GitHubConfiguration.normalizeApiUri(sb.toString());
    }
}

